/* KinokoNestedDataSection.cc */
/* Created by Enomoto Sanshiro on 19 November 2000. */
/* Last updated by Enomoto Sanshiro on 25 January 2002. */


#include <iostream>
#include <string>
#include <vector>
#include <map>
#include "ParaTokenizer.hh"
#include "KinokoDataSource.hh"
#include "KinokoDataSection.hh"
#include "KinokoDataSectionContainer.hh"
#include "KinokoNestedDataSection.hh"

using namespace std;


TKinokoNestedDataSection::TKinokoNestedDataSection(TKinokoDataSource* DataSource, const string& SectionName)
: TKinokoDataSection(DataSource, SectionName)
{
    _Formatter = 0;
    _Scanner = 0;
}

TKinokoNestedDataSection::TKinokoNestedDataSection(TKinokoDataSource* DataSource, const string& SectionName, int SectionId)
: TKinokoDataSection(DataSource, SectionName, SectionId)
{
    _Formatter = 0;
    _Scanner = 0;
}

TKinokoNestedDataSection::~TKinokoNestedDataSection()
{
    delete _Formatter;
    delete _Scanner;
}

int TKinokoNestedDataSection::SectionType(void) const
{
    return TKinokoDataSection::SectionType_Nested;
}

void TKinokoNestedDataSection::AddDataSection(TKinokoDataSection* DataSection)
{
    TKinokoDataSectionContainer::AddDataSection(DataSection);
    DataSection->SetParent(this);
}

void TKinokoNestedDataSection::ReadFrom(TParaTokenizer& Tokenizer) throw(TKinokoException)
{
    TKinokoDataSection* DataSection;
    TKinokoDataSectionFactory* SectionFactory;
    SectionFactory = TKinokoDataSectionFactory::GetInstance();

    try {
	Tokenizer.Next().MustBe("{");
	while (Tokenizer.LookAhead().Is("section")) {
	    DataSection = SectionFactory->ReadFrom(Tokenizer, _DataSource);
	    AddDataSection(DataSection);
	}
	Tokenizer.Next().MustBe("}");
    }
    catch (TScriptException &e) {
	throw TKinokoException(
	    "TKinokoNestedDataSection::ReadFrom()",
	    "script exception: " + e.Message()
	);
    }
    catch (TKinokoException &e) {
	throw TKinokoException(
	    "TKinokoNestedDataSection::ReadFrom()",
	    e.Message()
	);
    }
}

void TKinokoNestedDataSection::WriteTo(ostream& os, const string& Indent)
{
    os << Indent << "section \"" << _SectionName << "\"<" << _SectionId << ">";
    os << ": nested {";

    for (unsigned i = 0; i < _DataSectionList.size(); i++) {
	os << endl;
	_DataSectionList[i]->WriteTo(os, Indent + "    ");
    }

    os << Indent << "}" << endl;
}



TKinokoNestedDataSectionFormatter::TKinokoNestedDataSectionFormatter(TKinokoNestedDataSection* DataSection)
: TKinokoDataSectionFormatter(DataSection)
{
}

TKinokoNestedDataSectionFormatter::~TKinokoNestedDataSectionFormatter()
{
}



TKinokoNestedDataSectionScanner::TKinokoNestedDataSectionScanner(TKinokoNestedDataSection* DataSection)
{
}

TKinokoNestedDataSectionScanner::~TKinokoNestedDataSectionScanner()
{
}
