/* KinokoTaggedDataSection.hh */
/* Created by Enomoto Sanshiro on 19 November 2000. */
/* Last updated by Enomoto Sanshiro on 19 November 2000. */


#ifndef __KinokoTaggedDataSection_hh__
#define __KinokoTaggedDataSection_hh__


#include <iostream>
#include <string>
#include <vector>
#include <map>
#include "ParaTokenizer.hh"
#include "KinokoDataSection.hh"


class TKinokoTaggedDataSectionFormatter;
class TKinokoTaggedDataSectionScanner;


class TKinokoTaggedDataSection: public TKinokoDataSection {
  public:
    typedef std::map<long, std::string> TValueNameTable;
  public:
    TKinokoTaggedDataSection(TKinokoDataSource* DataSource, const std::string& SectionName);
    TKinokoTaggedDataSection(TKinokoDataSource* DataSource, const std::string& SectionName, int SectionId);
    virtual ~TKinokoTaggedDataSection();
    virtual int SectionType(void) const;
    virtual void ReadFrom(TParaTokenizer& Tokenizer) throw(TKinokoException);
    virtual void WriteTo(std::ostream& os, const std::string& Indent);
    inline TKinokoTaggedDataSectionFormatter* Formatter(void);
    inline TKinokoTaggedDataSectionScanner* Scanner(void);
  public:
    int AddField(const std::string& FieldName, int ValueWidth, TValueNameTable* ValueNameTable = 0);
    bool HasField(const std::string& FieldName);
    int FieldIndexOf(const std::string& FieldName) throw(TKinokoException);
    std::string FieldNameOf(int FieldIndex) throw(TKinokoException);
    int NumberOfFields(void);
  protected:
    int _NumberOfFields;
    std::vector<std::string> _FieldNameList;
    std::map<std::string, long> _FieldNameTable;
    std::vector<int> _ValueWidthList;
    std::vector<TValueNameTable*> _ValueNameTableList;
    TKinokoTaggedDataSectionFormatter* _Formatter;
    TKinokoTaggedDataSectionScanner* _Scanner;
};


class TKinokoTaggedDataSectionFormatter: public TKinokoDataSectionFormatter {
  public:
    TKinokoTaggedDataSectionFormatter(TKinokoTaggedDataSection* DataSection);
    virtual ~TKinokoTaggedDataSectionFormatter();
    inline int DataSize(void) const;
    inline int WriteTo(void* Buffer, int FieldIndex, int Value) const;
  protected:
    TKinokoTaggedDataSection* _TaggedDataSection;
  public:
    enum {
	Offset_Base = TKinokoDataSectionFormatter::Offset_DataArea
    };
};


class TKinokoTaggedDataSectionScanner: public TKinokoDataSectionScanner {
  public:
    TKinokoTaggedDataSectionScanner(TKinokoTaggedDataSection* DataSection);
    virtual ~TKinokoTaggedDataSectionScanner();
    inline void ReadFrom(void* Buffer, int FieldIndex, int& Value) const;
  public:
    enum {
	Offset_DataAreaSize = TKinokoDataSectionFormatter::Offset_DataAreaSize,
	Offset_Base = TKinokoDataSectionFormatter::Offset_DataArea
    };
};



inline TKinokoTaggedDataSectionFormatter* TKinokoTaggedDataSection::Formatter(void)
{
    if (_Formatter == 0) {
	_Formatter = new TKinokoTaggedDataSectionFormatter(this);
    }

    return _Formatter;
}

inline TKinokoTaggedDataSectionScanner* TKinokoTaggedDataSection::Scanner(void)
{
    if (_Scanner == 0) {
	_Scanner = new TKinokoTaggedDataSectionScanner(this);
    }

    return _Scanner;
}



inline int TKinokoTaggedDataSectionFormatter::DataSize(void) const
{
    return sizeof(U32bit) * _TaggedDataSection->NumberOfFields();
}

inline int TKinokoTaggedDataSectionFormatter::WriteTo(void* Buffer, int FieldIndex, int Value) const
{
    ((U32bit*) Buffer)[Offset_Base + FieldIndex] = Value;
    return sizeof(U32bit);
}



inline void TKinokoTaggedDataSectionScanner::ReadFrom(void* Buffer, int FieldIndex, int& Value) const
{
    Value = ((U32bit*) Buffer)[Offset_Base + FieldIndex];
}


#endif
