/* KinokoControllerMessenger.cc */
/* Created by Enomoto Sanshiro on 8 October 1999. */
/* Last updated by Enomoto Sanshiro on 30 September 2002. */


#include "RoomDeviceFactory.hh"
#include "KinokoMetaDeviceMessenger.hh"
#include "KinokoControllerMessenger.hh"

using namespace std;


TKinokoVmeControllerMessenger::TKinokoVmeControllerMessenger(TKinokoDaqBuilder* DaqBuilder)
: TParaObjectPrototype("VmeController")
{
    _VmeController = 0;
    _DaqBuilder = DaqBuilder;
}

TKinokoVmeControllerMessenger::~TKinokoVmeControllerMessenger()
{
}

TParaObjectPrototype* TKinokoVmeControllerMessenger::Clone(void)
{
    return new TKinokoVmeControllerMessenger(_DaqBuilder);
}

void TKinokoVmeControllerMessenger::Construct(const string& ClassName, vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    TParaObjectPrototype::Construct(ClassName, ArgumentList);

    _ControllerName = this->ObjectName();

    if (ArgumentList.size() > 0) {
        Assign(ArgumentList);
    }
}

string TKinokoVmeControllerMessenger::ControllerName(void)
{
    return _ControllerName;
}

int TKinokoVmeControllerMessenger::DispatchMessage(const string& Message, vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if ((Message == "assign") || (Message == "Assign")) {
        ReturnValue = Assign(ArgumentList);
    }
    else {
	return 0;
    }

    return 1;
}

TParaValue TKinokoVmeControllerMessenger::Assign(vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    string DeviceName = "";
    if (ArgumentList.size() > 0) {
	DeviceName = ArgumentList[0]->AsString();
    }

    TRoomDeviceFactory* DeviceFactory = TRoomDeviceFactory::GetInstance();
    try {
        _VmeController = DeviceFactory->CreateVmeController(DeviceName);
    }
    catch (THardwareException& e) {
	throw TScriptException(
	    "unknown vme controller: " + DeviceName + ": " + e.Message()
	);
    }

    _DaqBuilder->RegisterController(_ControllerName, _VmeController);
    
    return TParaValue((long) 0); 
}



TKinokoCamacControllerMessenger::TKinokoCamacControllerMessenger(TKinokoDaqBuilder* DaqBuilder)
: TParaObjectPrototype("CamacController")
{
    _CamacController = 0;
    _DaqBuilder = DaqBuilder;
}

TKinokoCamacControllerMessenger::~TKinokoCamacControllerMessenger()
{
}

TParaObjectPrototype* TKinokoCamacControllerMessenger::Clone(void)
{
    return new TKinokoCamacControllerMessenger(_DaqBuilder);
}

void TKinokoCamacControllerMessenger::Construct(const string& ClassName, vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    TParaObjectPrototype::Construct(ClassName, ArgumentList);

    _ControllerName = this->ObjectName();

    if (ArgumentList.size() > 0) {
        Assign(ArgumentList);
    }
}

string TKinokoCamacControllerMessenger::ControllerName(void)
{
    return _ControllerName;
}

int TKinokoCamacControllerMessenger::DispatchMessage(const string& Message, vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if ((Message == "assign") || (Message == "Assign")) {
        ReturnValue = Assign(ArgumentList);
    }
    else if ((Message == "initialize") || (Message == "Initialize")) {
        ReturnValue = Initialize(ArgumentList);
    }
    else if ((Message == "clear") || (Message == "Clear")) {
        ReturnValue = Clear(ArgumentList);
    }
    else if ((Message == "setInhibition") || (Message == "SetInhibition")) {
        ReturnValue = SetInhibition(ArgumentList);
    }
    else if ((Message == "releaseInhibition") || (Message == "ReleaseInhibition")) {
        ReturnValue = ReleaseInhibition(ArgumentList);
    }
    else {
	return 0;
    }
    
    return 1;
}

TParaValue TKinokoCamacControllerMessenger::Assign(vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    string DeviceName = "";
    if (ArgumentList.size() > 0) {
	DeviceName = ArgumentList[0]->AsString();
    }

    TRoomDeviceFactory* DeviceFactory = TRoomDeviceFactory::GetInstance();
    try {
        _CamacController = DeviceFactory->CreateCamacController(DeviceName);
    }
    catch (THardwareException& e) {
	throw TScriptException(
	    "unknown camac controller: " + DeviceName + ": " + e.Message()
	);
    }

    _DaqBuilder->RegisterController(_ControllerName, _CamacController);
    
    return TParaValue((long) 0); 
}

TParaValue TKinokoCamacControllerMessenger::Initialize(std::vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    if (_CamacController == 0) {
        throw TScriptException("driver not assigned: " + _ControllerName);
    }

    TKinokoReadoutAction* ReadoutAction = new TKinokoCamacControllerAction(
        _CamacController, _ControllerName, 
	TKinokoCamacControllerAction::CamacControllerAction_Initialize
    );

    try {
	_DaqBuilder->AddReadoutAction(ReadoutAction);
    }
    catch (TKinokoException &e) {
	throw TScriptException(
	    _ControllerName + ".initialize(): " + e.Message()
	);
    }

    return TParaValue((long) 0);     
}

TParaValue TKinokoCamacControllerMessenger::Clear(std::vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    if (_CamacController == 0) {
        throw TScriptException("driver not assigned: " + _ControllerName);
    }

    TKinokoReadoutAction* ReadoutAction = new TKinokoCamacControllerAction(
        _CamacController, _ControllerName, 
	TKinokoCamacControllerAction::CamacControllerAction_Clear
    );

    try {
	_DaqBuilder->AddReadoutAction(ReadoutAction);
    }
    catch (TKinokoException &e) {
	throw TScriptException(
	    _ControllerName + ".clear(): " + e.Message()
	);
    }

    return TParaValue((long) 0); 
}

TParaValue TKinokoCamacControllerMessenger::SetInhibition(std::vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    if (_CamacController == 0) {
        throw TScriptException("driver not assigned: " + _ControllerName);
    }

    TKinokoReadoutAction* ReadoutAction = new TKinokoCamacControllerAction(
        _CamacController, _ControllerName, 
	TKinokoCamacControllerAction::CamacControllerAction_SetInhibition
    );

    try {
	_DaqBuilder->AddReadoutAction(ReadoutAction);
    }
    catch (TKinokoException &e) {
	throw TScriptException(
	    _ControllerName + ".setInhibition(): " + e.Message()
	);
    }

    return TParaValue((long) 0); 
}

TParaValue TKinokoCamacControllerMessenger::ReleaseInhibition(std::vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    if (_CamacController == 0) {
        throw TScriptException("driver not assigned: " + _ControllerName);
    }

    TKinokoReadoutAction* ReadoutAction = new TKinokoCamacControllerAction(
        _CamacController, _ControllerName, 
	TKinokoCamacControllerAction::CamacControllerAction_ReleaseInhibition
    );

    try {
	_DaqBuilder->AddReadoutAction(ReadoutAction);
    }
    catch (TKinokoException &e) {
	throw TScriptException(
	    _ControllerName + ".releaseInhibition(): " + e.Message()
	);
    }

    return TParaValue((long) 0); 
}



TKinokoVmeCamacBridgeMessenger::TKinokoVmeCamacBridgeMessenger(TKinokoDaqBuilder* DaqBuilder)
: TKinokoCamacControllerMessenger(DaqBuilder)
{
    _VmeModule = 0;
    _InternalClassName = "VmeCamacBridge";
}

TKinokoVmeCamacBridgeMessenger::~TKinokoVmeCamacBridgeMessenger()
{
}

TParaObjectPrototype* TKinokoVmeCamacBridgeMessenger::Clone(void)
{
    return new TKinokoVmeCamacBridgeMessenger(_DaqBuilder);
}

TParaValue TKinokoVmeCamacBridgeMessenger::Assign(std::vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    string DeviceName = "";
    if (ArgumentList.size() > 0) {
	DeviceName = ArgumentList[0]->AsString();
    }

    TRoomDeviceFactory* DeviceFactory = TRoomDeviceFactory::GetInstance();
    try {
	TRoomVmeCamacBridge* Bridge = DeviceFactory->CreateVmeCamacBridge(DeviceName);
        _CamacController = Bridge;
        _VmeModule = Bridge;
    }
    catch (THardwareException& e) {
	throw TScriptException(
	    "unknown vme-camac bridge: " + DeviceName + ": " + e.Message()
	);
    }

    _DaqBuilder->RegisterController(_ControllerName, _CamacController);
    
    return TParaValue((long) 0); 
}



TKinokoVmeCrateMessenger::TKinokoVmeCrateMessenger(TKinokoDaqBuilder* DaqBuilder, bool IsScriptTest)
: TParaObjectPrototype("VmeCrate")
{
    _DaqBuilder = DaqBuilder;
    _IsScriptTest = IsScriptTest;

     TRoomDeviceFactory* DeviceFactory = TRoomDeviceFactory::GetInstance();
    _VmeCrate = DeviceFactory->CreateVmeCrate();

    _CrateName = this->ObjectName();
    _DaqBuilder->RegisterCrate(_CrateName, _VmeCrate);
}

TKinokoVmeCrateMessenger::~TKinokoVmeCrateMessenger()
{
}

TParaObjectPrototype* TKinokoVmeCrateMessenger::Clone(void)
{
    return new TKinokoVmeCrateMessenger(_DaqBuilder, _IsScriptTest);
}

void TKinokoVmeCrateMessenger::Construct(const string& ClassName, vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    TParaObjectPrototype::Construct(ClassName, ArgumentList);
}

int TKinokoVmeCrateMessenger::DispatchMessage(const string& Message, vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if ((Message == "installController") || (Message == "InstallController")) {
        ReturnValue = InstallController(ArgumentList);
    }
    else if ((Message == "installModule") || (Message == "InstallModule")) {
        ReturnValue = InstallModule(ArgumentList);
    }
    else {
	return 0;
    }

    return 1;
}

TParaValue TKinokoVmeCrateMessenger::InstallController(vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    if (
	(ArgumentList.size() != 1) || 
	(! ArgumentList[0]->IsObject("VmeController"))
    ){
        throw TScriptException(
	    "VmeCrate::installController()", "vme controller is expected."
	);
    }

    TRoomVmeController* Controller;
    TParaObjectPrototype* Messenger = ArgumentList[0]->AsObject();
    Controller = ((TKinokoVmeControllerMessenger*) Messenger)->_VmeController;
    if (Controller == 0) {
	throw TScriptException(
	    "driver not assigned: " + Messenger->ObjectName()
	);
    }

    if (_IsScriptTest) {
	return TParaValue((long) 0); 
    }

    try {
	_VmeCrate->InstallController(Controller);
    }
    catch (THardwareException &e) {
	throw TScriptException(e.Message());
    }

    return TParaValue((long) 0); 
}

TParaValue TKinokoVmeCrateMessenger::InstallModule(vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    if (ArgumentList.size() != 2 && ArgumentList.size() != 4) {
        throw TScriptException("wrong number of arguments");
    }

    TRoomVmeModule* Module = 0;

    if (ArgumentList[0]->IsObject("VmeModule")) {
	TParaObjectPrototype* Messenger = ArgumentList[0]->AsObject();
	Module = ((TKinokoVmeModuleMessenger*) Messenger)->_VmeModule;
    }
    else if (ArgumentList[0]->IsObject("VmeCamacBridge")) {
	TParaObjectPrototype* Messenger = ArgumentList[0]->AsObject();
	Module = ((TKinokoVmeCamacBridgeMessenger*) Messenger)->_VmeModule;
    }
    else {
        throw TScriptException(
	    "VmeCrate::installModule()", "vme module is expected."
	);
    }

    if (Module == 0) {
	throw TScriptException(
	    "driver not assigned: " + ArgumentList[0]->AsObject()->ObjectName()
	);
    }

    if (_IsScriptTest) {
	return TParaValue((long) 0); 
    }

    try {
	long BaseAddress = ArgumentList[1]->AsLong();
	if (ArgumentList.size() == 2) {
	    _VmeCrate->Install(Module, BaseAddress);
	}
	else {
	    long InterruptNumber = ArgumentList[2]->AsLong();
	    long Vector = ArgumentList[3]->AsLong();
	    _VmeCrate->Install(Module, BaseAddress, InterruptNumber, Vector);
	}
    }
    catch (THardwareException &e) {
	throw TScriptException(e.Message());
    }

    return TParaValue((long) 0); 
}



TKinokoCamacCrateMessenger::TKinokoCamacCrateMessenger(TKinokoDaqBuilder* DaqBuilder, bool IsScriptTest)
: TParaObjectPrototype("CamacCrate")
{
    _DaqBuilder = DaqBuilder;
    _IsScriptTest = IsScriptTest;

     TRoomDeviceFactory* DeviceFactory = TRoomDeviceFactory::GetInstance();
    _CamacCrate = DeviceFactory->CreateCamacCrate();

    _CrateName = this->ObjectName();
    _DaqBuilder->RegisterCrate(_CrateName, _CamacCrate);
}

TKinokoCamacCrateMessenger::~TKinokoCamacCrateMessenger()
{
}

TParaObjectPrototype* TKinokoCamacCrateMessenger::Clone(void)
{
    return new TKinokoCamacCrateMessenger(_DaqBuilder, _IsScriptTest);
}

void TKinokoCamacCrateMessenger::Construct(const string& ClassName, vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    TParaObjectPrototype::Construct(ClassName, ArgumentList);
}

int TKinokoCamacCrateMessenger::DispatchMessage(const string& Message, vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if ((Message == "installController") || (Message == "InstallController")) {
        ReturnValue = InstallController(ArgumentList);
    }
    else if ((Message == "installModule") || (Message == "InstallModule")) {
        ReturnValue = InstallModule(ArgumentList);
    }
    else {
	return 0;
    }

    return 1;
}

TParaValue TKinokoCamacCrateMessenger::InstallController(vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    if (ArgumentList.size() != 1) {
        throw TScriptException(
	    "CamacCrate::installController()", "wrong number of argument[s]"
	);
    }

    TRoomCamacController* Controller = 0;
    if (ArgumentList[0]->IsObject("CamacController")) {
	TParaObjectPrototype* Messenger = ArgumentList[0]->AsObject();
	Controller = ((TKinokoCamacControllerMessenger*) Messenger)->_CamacController;
    }
    else if (ArgumentList[0]->IsObject("VmeCamacBridge")) {
	TParaObjectPrototype* Messenger = ArgumentList[0]->AsObject();
	Controller = ((TKinokoVmeCamacBridgeMessenger*) Messenger)->_CamacController;
    }
    else {
        throw TScriptException(
	    "CamacCrate::installController()", "CAMAC controller is expected"
	);
    }

    if (Controller == 0) {
	throw TScriptException(
	     "driver not assigned: " + ArgumentList[0]->AsObject()->ObjectName()
	);
    }

    if (_IsScriptTest) {
	return TParaValue((long) 0); 
    }

    try {
	_CamacCrate->InstallController(Controller);
    }
    catch (THardwareException &e) {
	throw TScriptException(e.Message());
    }

    return TParaValue((long) 0); 
}

TParaValue TKinokoCamacCrateMessenger::InstallModule(vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    if (ArgumentList.size() != 2) {
        throw TScriptException("Too few arguments.");
    }
    if (! ArgumentList[0]->IsObject("CamacModule")) {
        throw TScriptException(
	    "CamacCrate::installModule()", "camac module is expected."
	);
    }

    TRoomCamacModule* Module;
    TParaObjectPrototype* Messenger = ArgumentList[0]->AsObject();
    Module = ((TKinokoCamacModuleMessenger*) Messenger)->_CamacModule;
    if (Module == 0) {
	throw TScriptException(
	     "driver not assigned: " + Messenger->ObjectName()
	);
    }

    if (_IsScriptTest) {
	return TParaValue((long) 0); 
    }

    long StationNumber = ArgumentList[1]->AsLong();
    try {
	_CamacCrate->Install(Module, StationNumber);
    }
    catch (THardwareException &e) {
	throw TScriptException(e.Message());
    }

    return TParaValue((long) 0); 
}

