/* KinokoDaqScript.cc */
/* Created by Enomoto Sanshiro on 9 October 1999. */
/* Last updated by Enomoto Sanshiro on 4 July 2001. */


#include <string>
#include <vector>
#include "ParaParser.hh"
#include "KiscScript.hh"
#include "KiscSystemScript.hh"
#include "KinokoDaqBuilder.hh"
#include "KinokoControllerMessenger.hh"
#include "KinokoModuleMessenger.hh"
#include "KinokoMetaDeviceMessenger.hh"
#include "KinokoDaqScriptStatement.hh"
#include "KinokoDaqScript.hh"

using namespace std;


TKinokoDaqScript::TKinokoDaqScript(TKinokoDaqBuilder* DaqBuilder, const string& ScriptFileName, bool IsScriptTest)
{
    _DaqBuilder = DaqBuilder;
    _ScriptFileName = ScriptFileName;
    _IsScriptTest = IsScriptTest;
}

TKinokoDaqScript::~TKinokoDaqScript()
{
}

TParaTokenTable* TKinokoDaqScript::CreateTokenTable(void)
{
    TParaTokenTable* TokenTable = TKiscScript::CreateTokenTable();

    TokenTable->AddKeyword("on");
    TokenTable->AddKeyword("invoke");
    TokenTable->AddKeyword("when");
    TokenTable->AddKeyword("unit");
    TokenTable->AddKeyword("attribute");
    
    return TokenTable;
}

TParaOperatorTable* TKinokoDaqScript::CreateOperatorTable(void)
{
    return TKiscScript::CreateOperatorTable();
}

TParaStatementTable* TKinokoDaqScript::CreateStatementTable(void)
{
    TParaStatementTable* StatementTable;
    StatementTable = TKiscScript::CreateStatementTable();

    StatementTable->AddStatement(
	new TKinokoDaqScriptOnStatement(_DaqBuilder)
    );
    StatementTable->AddStatement(
	new TKinokoDaqScriptInvokeStatement(_DaqBuilder)
    );
    StatementTable->AddStatement(
	new TKinokoDaqScriptWhenStatement(_DaqBuilder)
    );
    StatementTable->AddStatement(
	new TKinokoDaqScriptUnitStatement(_DaqBuilder)
    );
    StatementTable->AddStatement(
	new TKinokoDaqScriptAttributeStatement(_DaqBuilder)
    );

    return StatementTable;
}

TParaPackage* TKinokoDaqScript::CreatePackage(void)
{
    TParaPackage* Package = TKiscScript::CreatePackage();
    Package->AddEntry(
	new TKinokoDaqScriptDataSourceEntry(_DaqBuilder)
    );

    return Package;
}

TParaObjectPrototypeTable* TKinokoDaqScript::CreateObjectPrototypeTable(void)
{
    TParaObjectPrototypeTable* ObjectPrototypeTable;
    ObjectPrototypeTable = TKiscScript::CreateObjectPrototypeTable();

    ObjectPrototypeTable->RegisterClass(
	new TKinokoVmeControllerMessenger(_DaqBuilder)
    );
    ObjectPrototypeTable->RegisterClass(
	new TKinokoCamacControllerMessenger(_DaqBuilder)
    );
    ObjectPrototypeTable->RegisterClass(
	new TKinokoVmeCamacBridgeMessenger(_DaqBuilder)
    );
    ObjectPrototypeTable->RegisterClass(
	new TKinokoVmeCrateMessenger(_DaqBuilder, _IsScriptTest)
    );
    ObjectPrototypeTable->RegisterClass(
	new TKinokoCamacCrateMessenger(_DaqBuilder, _IsScriptTest)
    );
    ObjectPrototypeTable->RegisterClass(
	new TKinokoVmeModuleMessenger(_DaqBuilder)
    );
    ObjectPrototypeTable->RegisterClass(
	new TKinokoCamacModuleMessenger(_DaqBuilder)
    );
    ObjectPrototypeTable->RegisterClass(
	new TKinokoSoftwareModuleMessenger(_DaqBuilder)
    );
    ObjectPrototypeTable->RegisterClass(
	new TKinokoRegisterMessenger(_DaqBuilder)
    );
    ObjectPrototypeTable->RegisterClass(
	new TKinokoDataRecordMessenger(_DaqBuilder)
    );
    ObjectPrototypeTable->RegisterClass(
	new TKinokoReadoutChannelList()
    );

    return ObjectPrototypeTable;
}

TParaBuiltinFunctionTable* TKinokoDaqScript::CreateBuiltinFunctionTable(void)
{
    TParaBuiltinFunctionTable* BuiltinFunctionTable;
    BuiltinFunctionTable = TKiscScript::CreateBuiltinFunctionTable();

    BuiltinFunctionTable->RegisterAnonymousClass(
	new TKinokoDaqSystemMessenger(_DaqBuilder, _ScriptFileName)
    );

    return BuiltinFunctionTable;
}

vector<string> TKinokoDaqScript::DataSourceNameList(void)
{
    vector<string> EntryNameList = _Package->EntryNameList();
    vector<string> NameList;

    for (unsigned i = 0; i < EntryNameList.size(); i++) {
	TParaPackageEntry* Entry = _Package->GetEntry(EntryNameList[i]);
	if ((Entry != 0) && (Entry->EntryTypeName() == "datasource")) {
	    NameList.push_back(EntryNameList[i]);
	}
    }

    return NameList;
}
