/* KinokoDaqScript.hh */
/* Created by Enomoto Sanshiro on 9 October 1999. */
/* Last updated by Enomoto Sanshiro on 4 July 2001. */


#ifndef __KinokoDaqScript_hh__
#define __KinokoDaqScript_hh__


#include <string>
#include <vector>
#include "ParaParser.hh"
#include "KiscScript.hh"
#include "KiscSystemScript.hh"
#include "KinokoDaqBuilder.hh"


class TKinokoDaqScript: public TKiscScript {
  public:
    TKinokoDaqScript(TKinokoDaqBuilder* DaqBuilder, const std::string& ScriptFileName, bool IsScriptTest = false);
    virtual ~TKinokoDaqScript();
    virtual std::vector<std::string> DataSourceNameList(void);
  protected:
    virtual TParaObjectPrototypeTable* CreateObjectPrototypeTable(void);
    virtual TParaBuiltinFunctionTable* CreateBuiltinFunctionTable(void);
    virtual TParaTokenTable* CreateTokenTable(void);
    virtual TParaOperatorTable* CreateOperatorTable(void);
    virtual TParaStatementTable* CreateStatementTable(void);
    virtual TParaPackage* CreatePackage(void);
  protected:
    TKinokoDaqBuilder* _DaqBuilder;
    std::string _ScriptFileName;
    bool _IsScriptTest;
};


#endif
