/* KinokoMetaDeviceMessenger.hh */
/* Created by Enomoto Sanshiro on 4 July 2001. */
/* Last updated by Enomoto Sanshiro on 9 March 2003. */


#ifndef __KinokoMetaDeviceMessenger_hh__
#define __KinokoMetaDeviceMessenger_hh__


#include <string>
#include <vector>
#include "ParaObject.hh"
#include "KinokoDaqBuilder.hh"
#include "KinokoReadoutAction.hh"
#include "KinokoMetaReadoutAction.hh"
#include "KinokoReadoutCondition.hh"
#include "KinokoDataRecord.hh"



class TKinokoRegisterMessenger: public TParaObjectPrototype {
  public:
    TKinokoRegisterMessenger(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoRegisterMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual TParaValue& EvaluateOperator(TParaOperator* Operator, TParaValue& LeftValue, TParaValue& RightValue, TParaSymbolTable* SymbolTable, TParaValue& Result) throw(TScriptException);
    virtual std::string RegisterName(void);
  protected:
    virtual TParaValue AddRegisterAction(const std::string& Message, std::vector<TParaValue*>& ArgumentList, int RegisterOperationId) throw(TScriptException);
    virtual TParaValue Dump(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  public:
    static std::string CreateRegisterName(void);
    static int* GetRegisterOf(TParaValue& Value, TKinokoDaqBuilder* DaqBuilder) throw(TScriptException);
    static int* GetConstRegisterOf(TParaValue& Value, TKinokoDaqBuilder* DaqBuilder) throw(TScriptException);
  protected:
    TKinokoDaqBuilder* _DaqBuilder;
    std::string _RegisterName;
    int* _Register;
    static int _RegisterCount;
};


class TKinokoReadoutConditionMessenger: public TParaObjectPrototype {
  public:
    TKinokoReadoutConditionMessenger(void);
    virtual ~TKinokoReadoutConditionMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual TParaValue& EvaluateOperator(TParaOperator* Operator, TParaValue& LeftValue, TParaValue& RightValue, TParaSymbolTable* SymbolTable, TParaValue& Result) throw(TScriptException);
    virtual TKinokoReadoutCondition* GetReadoutCondition(void) throw(TScriptException) = 0;
};


class TKinokoRegisterConditionMessenger: public TKinokoReadoutConditionMessenger {
  public:
    TKinokoRegisterConditionMessenger(const std::string& OperatorSymbol, int* Register, int Parameter);
    virtual ~TKinokoRegisterConditionMessenger();
    virtual TKinokoReadoutCondition* GetReadoutCondition(void) throw(TScriptException);
  protected:
    std::string _OperatorSymbol;
    int* _Register;
    int _Parameter;
};


class TKinokoComplexReadoutConditionMessenger: public TKinokoReadoutConditionMessenger {
  public:
    TKinokoComplexReadoutConditionMessenger(const std::string& OperatorSymbol, TKinokoReadoutConditionMessenger* LeftCondition, TKinokoReadoutConditionMessenger* RightCondition);
    virtual ~TKinokoComplexReadoutConditionMessenger();
    virtual TKinokoReadoutCondition* GetReadoutCondition(void) throw(TScriptException);
  protected:
    std::string _OperatorSymbol;
    TKinokoReadoutConditionMessenger* _LeftConditionMessenger;
    TKinokoReadoutConditionMessenger* _RightConditionMessenger;
};


class TKinokoDataRecordMessenger: public TParaObjectPrototype {
  public:
    TKinokoDataRecordMessenger(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoDataRecordMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    virtual TParaValue Fill(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue Send(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue Dump(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  protected:
    TKinokoDaqBuilder* _DaqBuilder;
    TKinokoTaggedDataSection* _DataSection;
    TKinokoDataRecord* _DataRecord;
    std::string _DataRecordName;
};


class TKinokoDaqSystemMessenger: public TParaObjectPrototype {
  public:
    TKinokoDaqSystemMessenger(TKinokoDaqBuilder* DaqBuilder, const std::string& ScriptFileName);
    virtual ~TKinokoDaqSystemMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    virtual TParaValue GetRegistry(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue SetRegistry(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue ReadRegistry(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue WriteRegistry(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue ReadTime(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue Suspend(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue Terminate(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue Echo(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue ScriptFileName(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  protected:
    TKinokoDaqBuilder* _DaqBuilder;
    std::string _ScriptFileName;
};


#endif
