/* KinokoModuleMessenger.hh */
/* Created by Enomoto Sanshiro on 8 October 1999. */
/* Last updated by Enomoto Sanshiro on 23 August 2001. */


#ifndef __KinokoModuleMessenger_hh__
#define __KinokoModuleMessenger_hh__


#include <string>
#include <vector>
#include "ParaObject.hh"
#include "RoomModule.hh"
#include "RoomVmeAccess.hh"
#include "RoomCamacAccess.hh"
#include "RoomSoftwareDevice.hh"
#include "KinokoDaqBuilder.hh"


class TKinokoVmeCrateMessenger;
class TKinokoCamacCrateMessenger;
class TKinokoReadoutChannelList;


class TKinokoModuleMessenger: public TParaObjectPrototype {
  public:
    TKinokoModuleMessenger(const std::string& Name, TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoModuleMessenger();
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual std::string ModuleName(void);
  protected:
    virtual TParaValue Assign(std::vector<TParaValue*>& ArgumentList) throw(TScriptException) = 0;
    virtual TParaValue Read(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue TagRead(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue BlockRead(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue SequentialRead(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue Enable(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue Disable(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue Clear(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue WaitData(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue WriteRegister(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue ReadRegister(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue MiscControl(const std::string& ControlName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  protected:
    TKinokoReadoutChannelList* GetChannelListOf(TParaValue* Argument);
  protected:
    TKinokoDaqBuilder* _DaqBuilder;
    TRoomModule* _Module;
    std::string _ModuleName;
    int _SectionId;
  private:
    TKinokoReadoutChannelList* _ChannelList;
};


class TKinokoVmeModuleMessenger: public TKinokoModuleMessenger {
  public:
    TKinokoVmeModuleMessenger(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoVmeModuleMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    virtual TParaValue Assign(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  private:
    friend class TKinokoVmeCrateMessenger; 
    TRoomVmeModule* _VmeModule;
};


class TKinokoCamacModuleMessenger: public TKinokoModuleMessenger {
  public:
    TKinokoCamacModuleMessenger(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoCamacModuleMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& Value) throw(TScriptException);
  protected:
    virtual TParaValue Assign(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual TParaValue Transact(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  private:
    friend class TKinokoCamacCrateMessenger; 
    TRoomCamacModule* _CamacModule;
};


class TKinokoSoftwareModuleMessenger: public TKinokoModuleMessenger {
  public:
    TKinokoSoftwareModuleMessenger(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoSoftwareModuleMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    virtual TParaValue Assign(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
  private:
    TRoomSoftwareModule* _SoftwareModule;
};


class TKinokoReadoutChannelList: public TParaObjectPrototype {
  public:
    TKinokoReadoutChannelList(void);
    virtual ~TKinokoReadoutChannelList();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  public:
    virtual const std::vector<int>& ChannelList(void);
    virtual const std::vector<std::pair<int, std::string> >& TaggedChannelList(void);
    virtual void ReadChannelBits(unsigned long ChannelBits);
    virtual void Clear(void);
  protected:
    virtual TParaValue Add(std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual void AddChannel(int Channel, std::string TagName = "");
  protected:
    std::vector<int> _ChannelList;
    std::vector<std::pair<int, std::string> > _TaggedChannelList;
};


#endif
