/* KinokoReadoutCondition.cc */
/* Created by Enomoto Sanshiro on 5 July 2001. */
/* Last updated by Enomoto Sanshiro on 5 July 2001. */


#include <iostream>
#include "KinokoReadoutCondition.hh"

using namespace std;


TKinokoReadoutCondition::TKinokoReadoutCondition(void)
{
}

TKinokoReadoutCondition::~TKinokoReadoutCondition()
{
}



TKinokoRegisterReadoutCondition::TKinokoRegisterReadoutCondition(int* Register, int Value, int OperatorId)
{
    _Register = Register;
    _Value = Value;
    _OperatorId = OperatorId;
}

TKinokoRegisterReadoutCondition::~TKinokoRegisterReadoutCondition()
{
}

bool TKinokoRegisterReadoutCondition::IsSatisfied(void)
{
    bool Result;

    switch (_OperatorId) {
      case Operator_Equal:
	Result = (*_Register == _Value);
	break;
      case Operator_NotEqual:
	Result = (*_Register != _Value);
	break;
      case Operator_GreaterThan:
	Result = (*_Register > _Value);
	break;
      case Operator_GreaterEqual:
	Result = (*_Register >= _Value);
	break;
      case Operator_LessThan:
	Result = (*_Register < _Value);
	break;
      case Operator_LessEqual:
	Result = (*_Register <= _Value);
	break;
      case Operator_BitAnd:
	Result = ((*_Register & _Value) != 0);
	break;
      case Operator_BitXor:
	Result = ((*_Register ^ _Value) != 0);
	break;
      default:
	Result = false;
    }

    return Result;
}

void TKinokoRegisterReadoutCondition::Dump(ostream& os)
{
    os << hex << "[" << _Register << "]";

    switch (_OperatorId) {
      case Operator_Equal:
	os << " == ";
	break;
      case Operator_NotEqual:
	os << " != ";
	break;
      case Operator_GreaterThan:
	os << " > ";
	break;
      case Operator_GreaterEqual:
	os << " >= ";
	break;
      case Operator_LessThan:
        os << " < ";
	break;
      case Operator_LessEqual:
	os << " >= ";
	break;
      case Operator_BitAnd:
        os << " & ";
	break;
      case Operator_BitXor:
        os << " ^ ";
	break;
      default:
	;
    }

    os << _Value;
    os << dec;
}



TKinokoComplexReadoutCondition::TKinokoComplexReadoutCondition(TKinokoReadoutCondition* Left, TKinokoReadoutCondition* Right, int OperatorId)
{
    _Left = Left;
    _Right = Right;
    _OperatorId = OperatorId;
}

TKinokoComplexReadoutCondition::~TKinokoComplexReadoutCondition()
{
    delete _Right;
    delete _Left;
}

bool TKinokoComplexReadoutCondition::IsSatisfied(void)
{
    bool Result;

    switch (_OperatorId) {
      case Operator_Not:
        Result = (! _Right->IsSatisfied());
	break;
      case Operator_And:
	Result = (_Left->IsSatisfied() && _Right->IsSatisfied());
	break;
      case Operator_Or:
	Result = (_Left->IsSatisfied() || _Right->IsSatisfied());
	break;
      default:
	Result = false;
    }

    return Result;
}

void TKinokoComplexReadoutCondition::Dump(ostream& os)
{
    if (_Left) {
	os << "(";
	_Left->Dump(os);
	os << ") ";
    }
	
    switch (_OperatorId) {
      case Operator_Not:
	os << "! ";
	break;
      case Operator_And:
	os << "&& ";
	break;
      case Operator_Or:
	os << "|| ";
	break;
      default:
	os << "?? ";
	;
    }
	
    if (_Right) {
	os << "(";
	_Right->Dump(os);
	os << ")";
    }
}
