/* KinokoReadoutCondition.hh */
/* Created by Enomoto Sanshiro on 5 July 2001. */
/* Last updated by Enomoto Sanshiro on 5 July 2001. */


#ifndef __KinokoReadoutCondition_hh__
#define __KinokoReadoutCondition_hh__


#include <iostream>


class TKinokoReadoutCondition {
  public:
    TKinokoReadoutCondition(void);
    virtual ~TKinokoReadoutCondition();
    virtual bool IsSatisfied(void) = 0;
    virtual void Dump(std::ostream& os) = 0;
};


class TKinokoRegisterReadoutCondition: public TKinokoReadoutCondition {
  public:
    TKinokoRegisterReadoutCondition(int* Register, int Value, int OperatorId);
    virtual ~TKinokoRegisterReadoutCondition();
    virtual bool IsSatisfied(void);
    virtual void Dump(std::ostream& os);
  protected:
    int* _Register;
    int _Value;
    int _OperatorId;
  public:
    enum TOperatorId {
	Operator_Equal,
	Operator_NotEqual,
	Operator_GreaterThan,
	Operator_GreaterEqual,
	Operator_LessThan,
	Operator_LessEqual,
	Operator_BitAnd,
	Operator_BitXor,
	_NumbefOfOperators
    };
};


class TKinokoComplexReadoutCondition: public TKinokoReadoutCondition {
  public:
    TKinokoComplexReadoutCondition(TKinokoReadoutCondition* Left, TKinokoReadoutCondition* Right, int OperatorId);
    virtual ~TKinokoComplexReadoutCondition();
    virtual bool IsSatisfied(void);
    virtual void Dump(std::ostream& os);
  protected:
    TKinokoReadoutCondition* _Left;
    TKinokoReadoutCondition* _Right;
    int _OperatorId;
  public:
    enum TOperatorId {
	Operator_Not,
	Operator_And,
	Operator_Or,
	_NumbefOfOperators
    };
};


#endif
