/* KinokoReadoutSequence.hh */
/* Created by Enomoto Sanshiro on 25 September 1999. */
/* Last updated by Enomoto Sanshiro on 6 November 2001. */


#ifndef __KinokoReadoutSequence_hh__
#define __KinokoReadoutSequence_hh__


#include <vector>
#include "KinokoStream.hh"
#include "KinokoReadoutAction.hh"
#include "KinokoReadoutCondition.hh"


class TKinokoReadoutSequence: public TKinokoReadoutAction {
  public:
    TKinokoReadoutSequence(void);
    TKinokoReadoutSequence(int* ArgumentRegister);
    TKinokoReadoutSequence(std::vector<int*> ArgumentRegisterList);
    virtual ~TKinokoReadoutSequence();
    virtual void AddReadoutAction(TKinokoReadoutAction* ReadoutAction);
    virtual void Initialize(void);
    virtual void Go(TKinokoOutputStream* OutputStream) throw(TKinokoException);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer) throw(TKinokoException);
    virtual void LoadArguments(int* ArgumentList, int NumberOfArguments);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    TKinokoReadoutAction** _ActionList;
    unsigned _ActionListCapacity;
    unsigned _ActionListSize;
    int** _ArgumentRegisterList;
    int _ArgumentListSize;
};


class TKinokoUnitedReadoutActions: public TKinokoReadoutSequence {
  public:
    TKinokoUnitedReadoutActions(TKinokoNestedDataSection* DataSection);
    virtual ~TKinokoUnitedReadoutActions();
    virtual void Initialize(void);
    virtual void Go(TKinokoOutputStream* OutputStream) throw(TKinokoException);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    TKinokoNestedDataSection* _DataSection;
    TKinokoNestedDataSectionFormatter* _Formatter;
};


class TKinokoConditionalReadoutSequence: public TKinokoReadoutSequence {
  public:
    TKinokoConditionalReadoutSequence(TKinokoReadoutCondition* Condition);
    virtual ~TKinokoConditionalReadoutSequence();
    virtual void Go(TKinokoOutputStream* OutputStream) throw(TKinokoException);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    TKinokoReadoutCondition* _Condition;
    bool _IsConditionSatisfied;
};


#endif
