/* KinokoTransaction.hh */
/* Created by Enomoto Sanshiro on 16 April 1999. */
/* Last updated by Enomoto Sanshiro on 29 March 2002. */


#ifndef __KinokoTransaction_hh__
#define __KinokoTransaction_hh__


#include <string>
#include <map>
#include "KinokoStream.hh"
#include "KinokoReadoutSequence.hh"
#include "KinokoDataStreamFormatter.hh"


class TKinokoTransaction {
  public:
    TKinokoTransaction(TKinokoDataSource* DataSource, TKinokoOutputStream* OutputStream);
    virtual ~TKinokoTransaction();
    virtual void AddReadoutSequence(int TriggerSourceId, TKinokoReadoutSequence* ReadoutSequence);
    virtual void AddDaqEventSequence(const std::string& EventName, TKinokoReadoutSequence* ReadoutSequence);
    virtual void SendDataDescriptorPacket(void) throw(TKinokoException);
    virtual void Initialize(void) throw(TKinokoException);
    virtual void Finalize(void) throw(TKinokoException);
    virtual int OnTrigger(int TriggerSourceId, int* ParameterList = 0, int NumberOfParameters = 0) throw(TKinokoException);
    virtual int OnCommand(const std::string& Command, int* ParameterList, int NumberOfParameters) throw(TKinokoException);
    virtual void Dump(std::ostream& os);
  protected:
    virtual void ExecuteSequence(TKinokoReadoutSequence* Sequence, int* ParameterList, int NumberOfParameters, int TrailerValue) throw(TKinokoException);
  protected:
    TKinokoDataSource* _DataSource;
    TKinokoOutputStream* _OutputStream;
    TKinokoDataStreamFormatter* _StreamFormatter;
    std::map<int, TKinokoReadoutSequence*> _ReadoutSequenceTable;
    std::map<std::string, TKinokoReadoutSequence*> _DaqEventSequenceTable;
    unsigned _CommandPacketSize, _TrailerPacketSize;
  private:
    int _LastTriggerSourceId;
    std::string _LastCommand;
    TKinokoReadoutSequence* _LastTriggerSequence;  
    TKinokoReadoutSequence* _LastCommandSequence;
  public:
    enum TTrapId {
	TrapIdBase = 0x00010000,
	TrapId_RunBegin = TrapIdBase | 0x0001,
	TrapId_RunEnd = TrapIdBase | 0x0002,
	TrapId_RunSuspend = TrapIdBase | 0x0003,
	TrapId_RunResume = TrapIdBase | 0x0004
    };
};


#endif
