/* KinokoTrigger.hh */
/* Created by Enomoto Sanshiro on 16 April 1999. */
/* Last updated by Enomoto Sanshiro on 29 March 2002. */


#ifndef __KinokoTrigger_hh__
#define __KinokoTrigger_hh__


#include <vector>
#include "RoomServiceRequester.hh"
#include "RoomModule.hh"
#include "KinokoDefs.hh"


class TKinokoTrigger {
  public:
    TKinokoTrigger(void);
    virtual ~TKinokoTrigger();
    virtual void AddTriggerSource(int TriggerSourceId, TRoomModule* TriggerSource);
    virtual void Initialize(void) throw(TKinokoException);
    virtual void Finalize(void) throw(TKinokoException);
    virtual bool Wait(int& TriggerSourceId, int& TriggerId) throw(TKinokoException);
    virtual void Clear(void) throw(TKinokoException);
    virtual void Stop(void);
    virtual bool IsStopRequested(void);
  protected:
    TRoomServiceRequestHandler* _RequestHandler;
    std::vector<std::pair<int, TRoomModule*> > _TriggerSourceList;
    bool _IsStopRequested;
};


#endif
