/* kinoko-buffer-test.cc */
/* Created by Enomoto Sanshiro on 20 April 1998. */
/* Last updated by Enomoto Sanshiro on 6 May 1998. */


#include <iostream>
#include <cstdio>
#include <cstring>
#include "MushTimer.hh"
#include "MushArgumentList.hh"
#include "KinokoDefs.hh"
#include "KinokoBufferClient.hh"

using namespace std;


#define SharedMemoryProjectID 100
#define MessageQueueProjectID 101
#define DisconnectMessage "bye"
#define SamplingInterval 3000000
#define MessageSize 256

TMushRealTimeTimer TimeKeeper(0, 100000);
TKinokoBufferStreamLogger BufferLogger(cout);


void Write(void) throw(TKinokoException)
{
    TKinokoBufferWriter BufferWriter(
	SharedMemoryProjectID, MessageQueueProjectID, 
	&TimeKeeper, &BufferLogger
    );

    char Message[MessageSize];
    void *Address;
    size_t Size;
 
   while (printf("Message> "), (fgets(Message, MessageSize, stdin) != NULL)) {
	*(strchr(Message, '\n')) = '\0';
	Size = strlen(Message) + 1;
	
	//for (int i = 0; i < 1024 * 1024 * 1024; i++) {
	    BufferWriter.GetWriteEntry(Address, Size);
	    if (Address != NULL) {
		memcpy(Address, Message, Size);
		BufferWriter.SendStrobe(Address, Size);
	    }
	    //TMushRealTimeTimer(0, 50000).Suspend();
        //}
    }

    Size = strlen(DisconnectMessage) + 1;
    BufferWriter.GetWriteEntry(Address, Size);
    if (Address != NULL) {
	strcpy((char *) Address, DisconnectMessage);
	BufferWriter.SendStrobe(Address, Size);
    }

    printf("\n");
}

void Read(void) throw(TKinokoException)
{
    TMushSignalHandler SignalHandler;
    TMushSignalCounter SignalCounter;
    SignalHandler.RegisterClient(SIGTERM, &SignalCounter);
    SignalHandler.RegisterClient(SIGINT, &SignalCounter);
    SignalHandler.StartHandling();

    TKinokoBufferReader BufferReader(
	SharedMemoryProjectID, MessageQueueProjectID, 
	&TimeKeeper, &BufferLogger
    );
    
    while (SignalCounter.SignalCount() == 0) {
	void *Address;
        size_t Size;

	if (BufferReader.GetReadEntry(Address, Size) > 0) {
	    printf("%s\n", (const char *) Address);
	    BufferReader.SendAcknowledge(Address);
	    if (strstr((char *) Address, DisconnectMessage) == Address) {
		break;
	    }
	}
	//TMushRealTimeTimer(0, SamplingInterval).Suspend();
    }
}

int main(int argc, char**argv)
{
    TMushArgumentList ArgumentList(argc, argv);

    try {
	if (ArgumentList[0][0] == 'r') {
	    Read();
	}
	else if (ArgumentList[0][0] == 'w') {
	    Write();
	}
	else {
	    cerr << "Usage: " << ArgumentList.ProgramName();
	    cerr << " reader/writer" << endl;
	}
    }
    catch (TKinokoException e) {
	cerr << e << endl;
    }

    return 0;
}
