/* KinokoKdfReader.hh */
/* Created by Enomoto Sanshiro on 23 February 2002. */
/* Last updated by Enomoto Sanshiro on 6 October 2002. */


#ifndef __KinokoKdfRecorder_hh__
#define __KinokoKdfRecorder_hh__


#include <string>
#include "KinokoFileStream.hh"
#include "KinokoKdfStorage.hh"
#include "KinokoDataDistributor.hh"
#include "KinokoDataProcessor.hh"


class TKinokoKdfReader: public TKinokoDataReceiver {
  public:
    TKinokoKdfReader(const std::string& DataFileName, bool IsRawKdf = false);
    virtual ~TKinokoKdfReader();
    virtual void Start(void) throw(TKinokoException);
    virtual bool ProcessNext(void) throw(TKinokoException);
    virtual void ProcessUntilRunBegin(void) throw(TKinokoException);
    virtual void RegisterAnalyzer(const std::string& DataSourceName, TKinokoDataAnalyzer* DataAnalyzer);
    virtual void RegisterCommonAnalyzer(TKinokoDataAnalyzer* DataAnalyzer);
  public:
    virtual TKinokoKdfStorage* Storage(void) throw(TKinokoException);
    virtual TKinokoStorageHeader* StorageHeader(void) throw(TKinokoException);
    virtual TKinokoDataDescriptor* DataDescriptor(void) throw(TKinokoException);
    virtual TKinokoInputFileStream* InputStream(void) throw(TKinokoException);
  protected:
    virtual void OnRunBegin(void) throw(TKinokoException);
    virtual void OnReceiveDataDescriptorPacket(void* DataPacket, long PacketSize) throw(TKinokoException);
    virtual void OnReceiveDataPacket(void* DataPacket, long PacketSize) throw(TKinokoException);
    virtual void OnReceiveTrailerPacket(void* DataPacket, long PacketSize) throw(TKinokoException);
  protected:
    virtual void Construct(void) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
  protected:
    std::string _DataFileName;
    TKinokoKdfStorage* _Storage;
    TKinokoStorageHeader* _StorageHeader;
    TKinokoInputFileStream* _InputFileStream;
    TKinokoDataDistributor* _DataDistributor;
    std::map<std::string, TKinokoDataAnalyzer*> _AnalyzerTable;
    std::vector<TKinokoDataAnalyzer*> _CommonAnalyzerList;
    std::map<std::string, TKinokoDataAnalyzerList*> _AnalyzerListTable;
    bool _IsRawKdf;
    bool _IsFirstRunBeginProcessed;
};

#endif
