/* KinokoKdfRecorder.cc */
/* Created by Enomoto Sanshiro on 12 October 2000. */
/* Last updated by Enomoto Sanshiro on 6 October 2002. */


#include <string>
#include "MushTimer.hh"
#include "KinokoFileStream.hh"
#include "KinokoNullStream.hh"
#include "KinokoStorage.hh"
#include "KinokoRecorder.hh"
#include "KinokoKdfStorage.hh"
#include "KinokoKdfRecorder.hh"


using namespace std;


TKinokoKdfRecorder::TKinokoKdfRecorder(bool IsRawKdf)
{
    _IsRawKdf = IsRawKdf;

    _Storage = 0;
    _StorageHeader = new TKinokoStorageHeader();

    _OutputNullStream = new TKinokoOutputNullStream();
    _OutputStream = _OutputNullStream;

    _IsOverWriteAllowed = false;
    _AccessMode = -1;

    _IsDataCompressionEnabled = false;
    _IsIndexEnabled = false;
}

TKinokoKdfRecorder::~TKinokoKdfRecorder()
{
    delete _OutputNullStream;
    delete _Storage;
    delete _StorageHeader;
}

void TKinokoKdfRecorder::SetDataFile(const string& FileName)
{
    _FileName = FileName;
}

void TKinokoKdfRecorder::AllowOverWrite(void)
{
    _IsOverWriteAllowed = true;
}

void TKinokoKdfRecorder::SetDataFileAccessMode(int AccessMode)
{
    _AccessMode = AccessMode;
}

void TKinokoKdfRecorder::EnableDataCompression(void)
{
    _IsDataCompressionEnabled = true;
}

void TKinokoKdfRecorder::EnableIndex(void)
{
    _IsIndexEnabled = true;
}

void TKinokoKdfRecorder::AddHeaderEntry(const std::string& Name, const std::string& Value)
{
    _StorageHeader->AddEntry(Name, Value);
}

void TKinokoKdfRecorder::ImportHeaderFrom(const std::string& FileName)
{
    TKinokoKdfStorage Storage(FileName);
    TKinokoStorageHeader Header;

    try {
	Storage.ReadHeader(Header);
    }
    catch (TKinokoException &e) {
	return;
    }

    for (unsigned i = 0; i < Header.NumberOfEntries(); i++) {
	_StorageHeader->AddEntry(Header.EntryNameAt(i), Header.ValueAt(i));
    }
}

void TKinokoKdfRecorder::OnConstruct(void) throw(TKinokoException)
{
    if (! _FileName.empty()) {
        _Storage = new TKinokoKdfStorage(_FileName, _IsRawKdf);

	if (_IsOverWriteAllowed) {
	    _Storage->AllowOverWrite();
	}
	if (_AccessMode > 0) {
	    _Storage->SetAccessMode(_AccessMode);
	}
	if (_IsDataCompressionEnabled) {
	    _Storage->EnableDataCompression();
	}
	if (_IsIndexEnabled) {
	    _Storage->EnableIndex();
	}

	_Storage->WriteHeader(*_StorageHeader);
	_OutputStream = _Storage->GetOutputStream();
    }
}

void TKinokoKdfRecorder::OnDestruct(void) throw(TKinokoException)
{
    delete _Storage;
    _Storage = 0;
}

void TKinokoKdfRecorder::OnReceivePacket(void* Packet, long PacketSize) throw(TKinokoException)
{
    long WrittenLength;
    do {
	WrittenLength = _OutputStream->Write(Packet, PacketSize);
    } while (WrittenLength == 0);

    if (WrittenLength != PacketSize) {
	throw TKinokoException(
	    "TKinokoKdfRecorder::ProcessData()", "stream I/O error (internal)"
	);
    }
}
