/* KinokoRecorder.hh */
/* Created by Enomoto Sanshiro on 12 October 2000. */
/* Last updated by Enomoto Sanshiro on 13 May 2001. */


#ifndef __KinokoRecorder_hh__
#define __KinokoRecorder_hh__


#include <string>
#include "MushTimer.hh"
#include "KinokoFileStream.hh"
#include "KinokoNullStream.hh"
#include "KinokoDataProcessor.hh"
#include "KinokoStorage.hh"


class TKinokoRecorder: public TKinokoDataConsumer {
  public:
    TKinokoRecorder(void);
    virtual ~TKinokoRecorder();
    virtual void SetDataFile(const std::string& FileName) = 0;
    virtual void AllowOverWrite(void) = 0;
    virtual void SetDataFileAccessMode(int AccessMode) = 0;
    virtual void EnableDataCompression(void) = 0;
    virtual void EnableIndex(void) = 0;
    virtual void AddHeaderEntry(const std::string& Name, const std::string& Value) = 0;
    virtual void ImportHeaderFrom(const std::string& FileName) = 0;
};


class TKinokoNullRecorder: public TKinokoRecorder {
  public:
    TKinokoNullRecorder(void);
    virtual ~TKinokoNullRecorder();
    virtual void SetDataFile(const std::string& FileName);
    virtual void AllowOverWrite(void);
    virtual void SetDataFileAccessMode(int AccessMode);
    virtual void EnableDataCompression(void);
    virtual void EnableIndex(void);
    virtual void AddHeaderEntry(const std::string& Name, const std::string& Value);
    virtual void ImportHeaderFrom(const std::string& FileName);
};


#endif
