/* KinokoStorageHeader.cc */
/* Created by Enomoto Sanshiro on 9 January 2000. */
/* Last updated by Enomoto Sanshiro on 23 January 2000. */


#include <iostream>
#include <string>
#include <vector>
#include <map>
#include "KinokoStorageHeader.hh"

using namespace std;


TKinokoStorageHeader::TKinokoStorageHeader(void)
{
}

TKinokoStorageHeader::~TKinokoStorageHeader()
{
}

void TKinokoStorageHeader::AddEntry(const string& Name, const string& Value)
{
    _HeaderEntryList.push_back(make_pair(Name, Value));
    _HeaderEntryTable[Name] = Value;
}

unsigned TKinokoStorageHeader::NumberOfEntries(void) const
{
    return _HeaderEntryList.size();
}

string TKinokoStorageHeader::EntryNameAt(unsigned Index) const
{
    if (Index < _HeaderEntryList.size()) {
	return _HeaderEntryList[Index].first;
    }
    else {
	return "";
    }
}

string TKinokoStorageHeader::ValueAt(unsigned Index) const
{
    if (Index < _HeaderEntryList.size()) {
	return _HeaderEntryList[Index].second;
    }
    else {
	return "";
    }
}

string TKinokoStorageHeader::ValueOf(const string& Name) const
{
    map<string, string>::const_iterator Entry = _HeaderEntryTable.find(Name);

    if (Entry != _HeaderEntryTable.end()) {
        return (*Entry).second;
    }
    else {
        return "";
    }
}

void TKinokoStorageHeader::WriteTo(ostream& os, const string& Prefix) const
{
    for (unsigned i = 0; i < NumberOfEntries(); i++) {
	os << Prefix << EntryNameAt(i) << ": " << ValueAt(i) << endl;
    }
}
