/* KinokoBufferStream.cc */
/* Created by Enomoto Sanshiro on 24 February 1998. */
/* Last updated by Enomoto Sanshiro on 17 April 2001. */


#include "KinokoBufferClient.hh"
#include "KinokoStream.hh"
#include "KinokoBufferStream.hh"

using namespace std;



TKinokoInputBufferStream::TKinokoInputBufferStream(TKinokoBufferReader *BufferReader)
: TKinokoInputStream(0, 0)
{
    _BufferReader = BufferReader;
}

TKinokoInputBufferStream::~TKinokoInputBufferStream()
{
}

void TKinokoInputBufferStream::Destroy(void)
{
    delete _BufferReader;
}

bool TKinokoInputBufferStream::HasData(void)
{
    return _BufferReader->HasData();
}

size_t TKinokoInputBufferStream::NextDataSize(void)
{
    return _BufferReader->NextDataSize();
}

int TKinokoInputBufferStream::Read(void *Address, size_t MaxSize) throw(TKinokoException)
{
    void* BufferAddress;
    size_t Size;
    _BufferReader->GetReadEntry(BufferAddress, Size);

    if (BufferAddress != 0) {
	memcpy(Address, BufferAddress, Size);
	_BufferReader->SendAcknowledge(BufferAddress);
    }
    else {
	Size = 0;
    }

    return Size;
}

int TKinokoInputBufferStream::NextEntry(void*& Address) throw(TKinokoException)
{
    size_t Size;
    _BufferReader->GetReadEntry(Address, Size);

    return Size;
}

void TKinokoInputBufferStream::Flush(void* Address) throw(TKinokoException)
{
    if (Address != 0) {
	_BufferReader->SendAcknowledge(Address);
    }
}

int TKinokoInputBufferStream::GetEntry(void*& Address) throw(TKinokoException)
{
    size_t Size;
    _BufferReader->GetReadEntry(Address, Size);

    return Size;
}

void TKinokoInputBufferStream::ReleaseEntry(void* Address) throw(TKinokoException)
{
    if (Address != 0) {
	_BufferReader->SendAcknowledge(Address);
    }
}



TKinokoOutputBufferStream::TKinokoOutputBufferStream(TKinokoBufferWriter *BufferWriter)
: TKinokoOutputStream(0, 0)
{
    _BufferWriter = BufferWriter;
}

TKinokoOutputBufferStream::~TKinokoOutputBufferStream()
{
}

void TKinokoOutputBufferStream::Destroy(void)
{
    delete _BufferWriter;
}

int TKinokoOutputBufferStream::Write(void* Address, size_t Size) throw(TKinokoException)
{
    void* BufferAddress;
    do {
	_BufferWriter->GetWriteEntry(BufferAddress, Size);
    } while (BufferAddress == 0);

    memcpy(BufferAddress, Address, Size);
    _BufferWriter->SendStrobe(BufferAddress, Size);

    return Size;
}

int TKinokoOutputBufferStream::NextEntry(void*& Address, size_t MaxSize) throw(TKinokoException)
{
    _BufferWriter->GetWriteEntry(Address, MaxSize);
    return (Address > 0) ? MaxSize : 0;
}

int TKinokoOutputBufferStream::Flush(void* Address, size_t Size) throw(TKinokoException)
{
    return ReleaseEntry(Address, Size);
}

int TKinokoOutputBufferStream::GetEntry(void*& Address, size_t MaxSize) throw(TKinokoException)
{
    _BufferWriter->GetWriteEntry(Address, MaxSize);
    return (Address > 0) ? MaxSize : 0;
}

int TKinokoOutputBufferStream::ReleaseEntry(void* Address, size_t Size) throw(TKinokoException)
{
    if (Address == 0) {
	return 0;
    }
    _BufferWriter->SendStrobe(Address, Size);

    return Size;
}
