/* KinokoNullStream.hh */
/* Created by Enomoto Sanshiro on 9 January 2001. */
/* Last updated by Enomoto Sanshiro on 17 April 2001. */


#ifndef __KinokoNullStream_hh__
#define __KinokoNullStream_hh__


#include "KinokoStream.hh"


class TKinokoInputNullStream: public TKinokoInputStream {
  public:
    TKinokoInputNullStream(void);
    virtual ~TKinokoInputNullStream();
    virtual void Destroy(void);
    virtual bool HasData(void);
    virtual size_t NextDataSize(void);
    virtual int Read(void *Address, size_t MaxSize) throw(TKinokoException);
    virtual int NextEntry(void *&Address) throw(TKinokoException);
    virtual void Flush(void* Address) throw(TKinokoException);
    virtual int GetEntry(void *&Address) throw(TKinokoException);
    virtual void ReleaseEntry(void* Address) throw(TKinokoException);
};


class TKinokoOutputNullStream: public TKinokoOutputStream {
  public:
    TKinokoOutputNullStream(void);
    virtual ~TKinokoOutputNullStream();
    virtual void Destroy(void);
    virtual int Write(void *Address, size_t Size) throw(TKinokoException);
    virtual int NextEntry(void *&Address, size_t MaxSize) throw(TKinokoException);
    virtual int Flush(void* Address, size_t Size) throw(TKinokoException);
    virtual int GetEntry(void *&Address, size_t MaxSize) throw(TKinokoException);
    virtual int ReleaseEntry(void* Address, size_t Size) throw(TKinokoException);
};


#endif
