/* KinokoStream.cc */
/* Created by Enomoto Sanshiro on 24 February 1998. */
/* Last updated by Enomoto Sanshiro on 21 January 2002. */


#include "KinokoDefs.hh"
#include "KinokoStream.hh"

using namespace std;


TKinokoStream::TKinokoStream(int LocalBufferSize, int LocalBufferEntryTableSize)
{
    _LocalBufferSize = LocalBufferSize;
    _LocalBufferEntryTableSize = LocalBufferEntryTableSize;

    _LocalBuffer = 0;
    _IsLocalBufferFull = false;

    _WorkAreaSize = 0;
    _WorkArea = 0;
}

TKinokoStream::~TKinokoStream() 
{
    delete[] _WorkArea;
    delete _LocalBuffer;
}

void TKinokoStream::Destroy(void) 
{
}

void TKinokoStream::SetLocalBufferSize(int LocalBufferSize, int LocalBufferEntryTableSize) throw(TKinokoException)
{
    if (_LocalBuffer != 0) {
	throw TKinokoException(
	    "TKinokoStream::SetLocalBufferSize()", "buffer is already created"
	);
    }

    _LocalBufferSize = LocalBufferSize;
    _LocalBufferEntryTableSize = LocalBufferEntryTableSize;
}

bool TKinokoStream::IsLocalBufferFull(void)
{
    return _IsLocalBufferFull;
}

void TKinokoStream::CreateLocalBuffer(void)
{
    if (_LocalBuffer == 0) {
	_LocalBuffer = new TKinokoStreamBuffer(_LocalBufferSize, _LocalBufferEntryTableSize);
    }
}

void TKinokoStream::ResizeWorkArea(size_t NewSize)
{
    delete[] _WorkArea;

    _WorkAreaSize = (size_t) (1.5 * NewSize);
    _WorkArea = new unsigned[_WorkAreaSize];
}



TKinokoInputStream::TKinokoInputStream(int LocalBufferSize, int LocalBufferEntryTableSize)
: TKinokoStream(LocalBufferSize, LocalBufferEntryTableSize)
{
}

TKinokoInputStream::~TKinokoInputStream() 
{
}



TKinokoOutputStream::TKinokoOutputStream(int LocalBufferSize, int LocalBufferEntryTableSize)
: TKinokoStream(LocalBufferSize, LocalBufferEntryTableSize)
{
}

TKinokoOutputStream::~TKinokoOutputStream() 
{
}



TKinokoStreamBuffer::TKinokoStreamBuffer(size_t BufferSize, int MaxNumberOfEntries)
{
    _BufferSize = BufferSize;
    _Buffer = new unsigned char [_BufferSize];

    _Arena = new TKinokoArena(_Buffer, _BufferSize, MaxNumberOfEntries);
}

TKinokoStreamBuffer::~TKinokoStreamBuffer()
{
    delete _Arena;
    delete[] _Buffer;
}

int TKinokoStreamBuffer::Allocate(void*& Address, size_t Size) throw(TKinokoException)
{
    static const int NumberOfAttached = 1;

    if (Size > _BufferSize) {
	throw TKinokoException(
	    "TKinokoStreamBuffer::Allocate()", "too large date size"
	);
    }

    if (! _Arena->IsAllocatable(Size)) {
	return 0;
    }

    if (! _Arena->CreateEntry(Size, Address, NumberOfAttached)) {
	return 0;
    }
    
    return Size;
}

void TKinokoStreamBuffer::Release(void* Address) throw(TKinokoException)
{
    if (! _Arena->DetachEntry(Address)) {
	throw TKinokoException(
	    "TKinokoStreamBuffer::Release()", "releasing invalid address"
	);
    }
}
