/* KinokoStream.hh */
/* Created by Enomoto Sanshiro on 23 February 1998. */
/* Last updated by Enomoto Sanshiro on 17 April 2001. */


#ifndef __KinokoStream_hh__
#define __KinokoStream_hh__


#include "KinokoDefs.hh"
#include "KinokoArena.hh"


class TKinokoStreamBuffer;

class TKinokoStream {
  public:
    TKinokoStream(int LocalBufferSize, int LocalBufferEntryTableSize);
    virtual ~TKinokoStream();
    virtual void Destroy(void);
    virtual void SetLocalBufferSize(int LocalBufferSize, int LocalBufferEntryTableSize) throw(TKinokoException);
    virtual bool IsLocalBufferFull(void);
  protected:
    virtual void CreateLocalBuffer(void);
    virtual void ResizeWorkArea(size_t NewSize);
  protected:
    size_t _WorkAreaSize;
    unsigned *_WorkArea;
    int _LocalBufferSize;
    int _LocalBufferEntryTableSize;
    TKinokoStreamBuffer* _LocalBuffer;
    bool _IsLocalBufferFull;
};


class TKinokoInputStream: public TKinokoStream {
  public:
    TKinokoInputStream(int BufferSize, int BufferEntryTableSize);
    virtual ~TKinokoInputStream();
    virtual bool HasData(void) = 0;
    virtual size_t NextDataSize(void) = 0;
    virtual int Read(void *Address, size_t MaxSize) throw(TKinokoException) = 0;
    virtual int NextEntry(void *&Address) throw(TKinokoException) = 0;
    virtual void Flush(void* Address) throw(TKinokoException) = 0;
    virtual int GetEntry(void *&Address) throw(TKinokoException) = 0;
    virtual void ReleaseEntry(void* Address) throw(TKinokoException) = 0;
};


class TKinokoOutputStream: public TKinokoStream {
  public:
    TKinokoOutputStream(int BufferSize, int BufferEntryTableSize);
    virtual ~TKinokoOutputStream();
    virtual int Write(void *Address, size_t Size) throw(TKinokoException) = 0;
    virtual int NextEntry(void *&Address, size_t MaxSize) throw(TKinokoException) = 0;
    virtual int Flush(void* Address, size_t Size) throw(TKinokoException) = 0;
    virtual int GetEntry(void *&Address, size_t MaxSize) throw(TKinokoException) = 0;
    virtual int ReleaseEntry(void* Address, size_t Size) throw(TKinokoException) = 0;
};


class TKinokoStreamBuffer {
  public:
    TKinokoStreamBuffer(size_t BufferSize, int MaxNumberOfEntries);
    virtual ~TKinokoStreamBuffer();
    virtual int Allocate(void*& Address, size_t Size) throw(TKinokoException);
    virtual void Release(void* Address) throw(TKinokoException);
  private:
    unsigned char* _Buffer;
    size_t _BufferSize;
    TKinokoArena* _Arena;
};



#endif
