/* Kinoko2dHistogramView.hh */
/* Created by Enomoto Sanshiro on 13 January 2001. */
/* Last updated by Enomoto Sanshiro on 13 January 2001. */


#ifndef __Kinoko2dHistogramView_hh__
#define __Kinoko2dHistogramView_hh__


#include <string>
#include <iostream>
#include "Kasp2dHistogram.hh"
#include "KinokoView.hh"


class TKinoko2dHistogramView: public TKinokoView {
  public:
    TKinoko2dHistogramView(TKasp2dHistogram* Histogram);
    virtual ~TKinoko2dHistogramView();
    virtual void SetAxisTitle(const std::string& XTitle, const std::string& YTitle);
    virtual void DisableZScale(void);
    virtual void SetZScaleLog(void);
    virtual void SetZScaleLinear(void);
  protected:
    virtual bool SetDrawOption(const std::string& OptionString);
    virtual void SaveThis(TKaspRepository* Repository) throw(TKinokoException);
    virtual void ClearThis(void);
  protected:
    TKasp2dHistogram* _Histogram;
    float _XMin, _XMax, _NumberOfXBins, _XBinStep;
    float _YMin, _YMax, _NumberOfYBins, _YBinStep;
    float _ZMin, _ZMax;
    std::string _XTitle, _YTitle;
    int _PlotType;
    bool _IsZScaleEnabled;
    bool _IsZScaleLog;
  public:
    enum T2dHistogramPlotType {
	PlotType_Scatter,
	PlotType_Box,
	PlotType_Color,
	PlotType_Gray,
	PlotType_Contour,
	_NumberOfHistogramTypes
    };
};



class TKinokoKoap2dHistogramView: public TKinoko2dHistogramView {
  public:
    TKinokoKoap2dHistogramView(TKasp2dHistogram* Histogram, std::ostream* OutputStream);
    virtual ~TKinokoKoap2dHistogramView();
  protected:
    virtual void DeployThis(void);
    virtual void DrawThis(void);
    virtual void ClearThis(void);
  protected:
    std::ostream* _OutputStream;
};


#endif
