/* KinokoHistogramView.hh */
/* Created by Enomoto Sanshiro on 4 November 2000. */
/* Last updated by Enomoto Sanshiro on 4 November 2000. */


#ifndef __KinokoHistogramView_hh__
#define __KinokoHistogramView_hh__


#include <iostream>
#include <string>
#include "KaspHistogram.hh"
#include "KinokoView.hh"


class TKinokoHistogramView: public TKinokoView {
  public:
    TKinokoHistogramView(TKaspHistogram* Histogram);
    virtual ~TKinokoHistogramView();
    virtual void SetYScaleLog(void);
    virtual void SetYScaleLinear(void);
    virtual void SetAxisTitle(const std::string& XTitle, const std::string& YTitle);
  protected:
    virtual void SaveThis(TKaspRepository* Repository) throw(TKinokoException);
    virtual void ClearThis(void);
  protected:
    TKaspHistogram* _Histogram;
    float _Min, _Max, _NumberOfBins, _BinStep;
    float _YMin, _YMax;
    bool _IsYScaleLog;
    std::string _XTitle, _YTitle;
};



class TKinokoKoapHistogramView: public TKinokoHistogramView {
  public:
    TKinokoKoapHistogramView(TKaspHistogram* Histogram, std::ostream* OutputStream);
    virtual ~TKinokoKoapHistogramView();
  protected:
    virtual void DeployThis(void);
    virtual void DrawThis(void);
    virtual void ClearThis(void);
  protected:
    std::ostream* _OutputStream;
};


#endif
