/* KinokoHistoryView.hh */
/* Created by Enomoto Sanshiro on 5 December 2000. */
/* Last updated by Enomoto Sanshiro on 29 September 2002. */


#ifndef __KinokoHistoryView_hh__
#define __KinokoHistoryView_hh__


#include <string>
#include <iostream>
#include "KaspHistory.hh"
#include "KinokoPlatform.hh"
#include "KinokoView.hh"


class TKinokoHistoryView: public TKinokoView {
  public:
    TKinokoHistoryView(TKaspHistory* History, double MinValue, double MaxValue, double WindowWidth);
    virtual ~TKinokoHistoryView();
    virtual void Draw(void);
    virtual void SetDisplayValue(int FieldId);
    virtual void SetYScaleLog(void);
    virtual void SetYScaleLinear(void);
    virtual void SetAxisTitle(const std::string& XTitle, const std::string& YTitle);
    virtual void DisableAutoHold(void);
    virtual void Hold(void);
    virtual void SetOperationRange(double LowerBound, double UpperBound);
    virtual void EnableAlarm(TKinokoEventEmitter* EventEmitter, const std::string& Message);
    virtual void DisableAlarm(void);
  protected:
    virtual void SaveThis(TKaspRepository* Repository) throw(TKinokoException);
    virtual void ClearThis(void);
  protected:
    virtual void CheckValueRange(double Value);
  protected:
    TKaspHistory* _History;
    int _DisplayValueFieldId;
    double _MinValue, _MaxValue;
    double _WindowWidth;
    double _LowerBound, _UpperBound;
    std::string _XTitle, _YTitle;
    int _MaxNumberOfSamples;
    TKinokoEventEmitter* _EventEmitter;
    std::string _AlarmMessage;
    bool _IsYScaleLog;
    bool _IsAutoHoldEnabled;
    bool _IsLastValueInRange;
  public:
    enum TFieldId {
        FieldId_Counts,
	FieldId_Sum,
	FieldId_Mean,
	FieldId_Deviation,
	_NumberOfFieldIds
    };
};



class TKinokoKoapHistoryView: public TKinokoHistoryView {
  public:
    TKinokoKoapHistoryView(TKaspHistory* History, double MinValue, double MaxValue, double WindowWidth, std::ostream* OutputStream);
    virtual ~TKinokoKoapHistoryView();
  protected:
    virtual void DeployThis(void);
    virtual void DrawThis(void);
    virtual void ClearThis(void);
  protected:
    virtual double DrawCountPlot(double MinTime, double MaxTime);
    virtual double DrawSumPlot(double MinTime, double MaxTime);
    virtual double DrawMeanPlot(double MinTime, double MaxTime, bool DrawsDeviation);
  protected:
    std::ostream* _OutputStream;
};


#endif
