/* KinokoMapView.hh */
/* Created by Enomoto Sanshiro on 2 April 2001. */
/* Last updated by Enomoto Sanshiro on 8 April 2001. */


#ifndef __KinokoMapView_hh__
#define __KinokoMapView_hh__


#include <iostream>
#include <string>
#include <map>
#include "KaspMap.hh"
#include "KinokoView.hh"


class TKinokoMapView: public TKinokoView {
  public:
    TKinokoMapView(TKaspMap* Map, float XMin, float XMax, float YMin, float YMax, float ZMin, float ZMax);
    virtual ~TKinokoMapView();
    virtual void AddPoint(int Address, float PositionX, float PositionY);
    virtual void SetPointSize(float Radius);
    virtual bool IsValidAddress(int Address);
    virtual float PositionXOf(int Address);
    virtual float PositionYOf(int Address);
    virtual float PointRadius(void);
  protected:
    virtual void SaveThis(TKaspRepository* Repository) throw(TKinokoException);
    virtual void ClearThis(void);
  protected:
    TKaspMap* _Map;
    std::map<int, std::pair<float, float> > _PositionTable;
    float _XMin, _XMax, _YMin, _YMax, _ZMin, _ZMax;
    float _PointRadius;
  private:
    int _LastAddress;
    std::map<int, std::pair<float, float> >::iterator _LastPosition;
};



class TKinokoKoapMapView: public TKinokoMapView {
  public:
    TKinokoKoapMapView(TKaspMap* Map, float XMin, float XMax, float YMin, float YMax, float ZMin, float ZMax, std::ostream* OutputStream);
    virtual ~TKinokoKoapMapView();
  protected:
    virtual void DeployThis(void);
    virtual void DrawThis(void);
    virtual void ClearThis(void);
  protected:
    std::ostream* _OutputStream;
};


#endif
