/* KinokoPictureView.cc */
/* Created by Enomoto Sanshiro on 12 July 2002. */
/* Last updated by Enomoto Sanshiro on 12 July 2002. */


#include <iostream>
#include <string>
#include "KinokoPictureView.hh"

using namespace std;


TKinokoPictureView::TKinokoPictureView(const string& Title, float XMin, float XMax, float YMin, float YMax)
{
    _Title = Title;
    _XMin = XMin; _XMax = XMax;
    _YMin = YMin; _YMax = YMax;
}

TKinokoPictureView::~TKinokoPictureView()
{
}

void TKinokoPictureView::SaveThis(TKaspRepository* Repository)throw(TKinokoException)
{
}

void TKinokoPictureView::ClearThis(void)
{
}



TKinokoKoapPictureView::TKinokoKoapPictureView(const string& Title, float XMin, float XMax, float YMin, float YMax, ostream* OutputStream)
: TKinokoPictureView(Title, XMin, XMax, YMin, YMax)
{
    _OutputStream = OutputStream;
}

TKinokoKoapPictureView::~TKinokoKoapPictureView()
{
}

void TKinokoKoapPictureView::DeployThis(void) 
{
    (*_OutputStream) << ".create picture " << _Name << " ";
    (*_OutputStream) << 100 * Left() << " " << 100 * Top() << " ";
    (*_OutputStream) << 100 * Width() << " " << 100 * Height() << ";" << endl;

    (*_OutputStream) << _Name << " set title " << _Title << ";" << endl;

    (*_OutputStream) << _Name << " frame ";
    (*_OutputStream) << _XMin << " " << _XMax << " ";
    (*_OutputStream) << _YMin << " " << _YMax << ";" << endl;
}

void TKinokoKoapPictureView::DrawThis(void)
{
}

void TKinokoKoapPictureView::ClearThis(void)
{
    TKinokoPictureView::ClearThis();
    
    (*_OutputStream) << _Name << " clear;" << endl;
    (*_OutputStream) << _Name << " drawframe;" << endl;
}
