/* KinokoPictureView.hh */
/* Created by Enomoto Sanshiro on 12 July 2002. */
/* Last updated by Enomoto Sanshiro on 12 July 2002. */


#ifndef __KinokoPictureView_hh__
#define __KinokoPictureView_hh__


#include <iostream>
#include <string>
#include "KinokoView.hh"


class TKinokoPictureView: public TKinokoView {
  public:
    TKinokoPictureView(const std::string& Title, float XMin, float XMax, float YMin, float YMax);
    virtual ~TKinokoPictureView();
  protected:
    virtual void SaveThis(TKaspRepository* Repository) throw(TKinokoException);
    virtual void ClearThis(void);
  protected:
    float _XMin, _XMax, _YMin, _YMax;
    std::string _Title;
};



class TKinokoKoapPictureView: public TKinokoPictureView {
  public:
    TKinokoKoapPictureView(const std::string& Title, float XMin, float XMax, float YMin, float YMax, std::ostream* OutputStream);
    virtual ~TKinokoKoapPictureView();
  protected:
    virtual void DeployThis(void);
    virtual void DrawThis(void);
    virtual void ClearThis(void);
  protected:
    std::ostream* _OutputStream;
};


#endif
