/* KinokoHistogramView.cc */
/* Created by Enomoto Sanshiro on 25 January 2001. */
/* Last updated by Enomoto Sanshiro on 25 January 2001. */


#include <strstream>
#include <cmath>
#include "KaspTabular.hh"
#include "KinokoTabularView.hh"

using namespace std;


TKinokoTabularView::TKinokoTabularView(TKaspTabular* Tabular, int NumberOfColumns)
{
    _Tabular = Tabular;
    _NumberOfColumns = NumberOfColumns;
}

TKinokoTabularView::~TKinokoTabularView()
{
}

void TKinokoTabularView::SaveThis(TKaspRepository* Repository)throw(TKinokoException)
{
    try {
	Repository->SaveTabular(_Name, _Tabular);
    }
    catch (TKaspException &e) {
	throw TKinokoException(
	    "TKinokoTabularView::SaveThis()", e.Message()
	);
    }
}

void TKinokoTabularView::ClearThis(void)
{
    _Tabular->Clear();
}




TKinokoKoapTabularView::TKinokoKoapTabularView(TKaspTabular* Tabular, int NumberOfColumns, ostream* OutputStream)
: TKinokoTabularView(Tabular, NumberOfColumns)
{
    _OutputStream = OutputStream;
}

TKinokoKoapTabularView::~TKinokoKoapTabularView()
{
}

void TKinokoKoapTabularView::DeployThis(void) 
{
    (*_OutputStream) << ".create textbox " << _Name << " ";
    (*_OutputStream) << 100 * Left() << " " << 100 * Top() << " ";
    (*_OutputStream) << 100 * Width() << " " << 100 * Height() << ";" << endl;

    (*_OutputStream) << _Name << " set title " << _Tabular->Title() << ";" << endl;
    (*_OutputStream) << _Name << " set columns " << _NumberOfColumns << ";" << endl;
    (*_OutputStream) << _Name << " drawframe;" << endl;
}

void TKinokoKoapTabularView::DrawThis(void)
{
    (*_OutputStream) << _Name << " clear;" << endl;
    (*_OutputStream) << _Name << " drawframe;" << endl;

    if (! _Tabular->HasData()) {
        (*_OutputStream) << _Name << " write ";
        (*_OutputStream) << "no data;" << endl;
	return;
    }

    int NumberOfFields = _Tabular->NumberOfFields();

    (*_OutputStream) << _Name << " write " << endl;
    for (int i = 0; i < NumberOfFields; i++) {
	(*_OutputStream) << _Tabular->FieldNameOf(i) << ": ";
	(*_OutputStream) << _Tabular->ValueOf(i) << endl;
    }
    (*_OutputStream) << ";" << endl;
}

void TKinokoKoapTabularView::ClearThis(void)
{
    TKinokoTabularView::ClearThis();
    
    (*_OutputStream) << _Name << " clear;" << endl;
    (*_OutputStream) << _Name << " drawframe;" << endl;
}
