/* KinokoTabularView.hh */
/* Created by Enomoto Sanshiro on 25 January 2001. */
/* Last updated by Enomoto Sanshiro on 25 January 2001. */


#ifndef __KinokoTabularView_hh__
#define __KinokoTabularView_hh__


#include <iostream>
#include <string>
#include "KaspTabular.hh"
#include "KinokoView.hh"


class TKinokoTabularView: public TKinokoView {
  public:
    TKinokoTabularView(TKaspTabular* Tabular, int NumberOfColumns);
    virtual ~TKinokoTabularView();
  protected:
    virtual void SaveThis(TKaspRepository* Repository) throw(TKinokoException);
    virtual void ClearThis(void);
  protected:
    TKaspTabular* _Tabular;
    int _NumberOfColumns;
};



class TKinokoKoapTabularView: public TKinokoTabularView {
  public:
    TKinokoKoapTabularView(TKaspTabular* Tabular, int NumberOfColumns, std::ostream* OutputStream);
    virtual ~TKinokoKoapTabularView();
  protected:
    virtual void DeployThis(void);
    virtual void DrawThis(void);
    virtual void ClearThis(void);
  protected:
    std::ostream* _OutputStream;
};


#endif
