/* KinokoViewAction.cc */
/* Created by Enomoto Sanshiro on 16 June 2002. */
/* Last updated by Enomoto Sanshiro on 29 September 2002. */


#include <string>
#include <map>
#include "MushMisc.hh"
#include "KinokoView.hh"
#include "KaspRepository.hh"
#include "KinokoViewAction.hh"

using namespace std;


TKinokoViewAction::TKinokoViewAction(void)
{
}

TKinokoViewAction::~TKinokoViewAction(void)
{
}



TKinokoViewDrawAction::TKinokoViewDrawAction(TKinokoView* View)
{
    _View = View;
}

TKinokoViewDrawAction::~TKinokoViewDrawAction()
{
}

void TKinokoViewDrawAction::Execute(void) throw(TKinokoException)
{
    _View->Draw();
}

void TKinokoViewDrawAction::Dump(ostream& os, const std::string& Indent)
{
    os << Indent << "Draw" << "\t" << _View->Name() << endl;
}



TKinokoViewClearAction::TKinokoViewClearAction(TKinokoView* View)
{
    _View = View;
}

TKinokoViewClearAction::~TKinokoViewClearAction()
{
}

void TKinokoViewClearAction::Execute(void) throw(TKinokoException)
{
    _View->Clear();
}

void TKinokoViewClearAction::Dump(ostream& os, const std::string& Indent)
{
    os << Indent << "Clear" << "\t" << _View->Name() << endl;
}



TKinokoViewSaveAction::TKinokoViewSaveAction(TKinokoView* View, TKaspRepository* Repository)
{
    _View = View;
    _Repository = Repository;
}

TKinokoViewSaveAction::~TKinokoViewSaveAction()
{
}

void TKinokoViewSaveAction::Execute(void) throw(TKinokoException)
{
    _View->Save(_Repository);
}

void TKinokoViewSaveAction::Dump(ostream& os, const std::string& Indent)
{
    os << Indent << "Save" << "\t" << _View->Name() << endl;
}



TKinokoHistoryViewDrawAction::TKinokoHistoryViewDrawAction(TKinokoHistoryView* HistoryView, int FieldId)
: TKinokoViewDrawAction(HistoryView)
{
    _HistoryView = HistoryView;
    _FieldId = FieldId;
}

TKinokoHistoryViewDrawAction::~TKinokoHistoryViewDrawAction()
{
}

void TKinokoHistoryViewDrawAction::Execute(void) throw(TKinokoException)
{
    _HistoryView->SetDisplayValue(_FieldId);
    TKinokoViewDrawAction::Execute();
}



TKinokoHistoryViewHoldAction::TKinokoHistoryViewHoldAction(TKinokoHistoryView* HistoryView, TKaspHistory* History)
{
    _HistoryView = HistoryView;
    _History = History;
}

TKinokoHistoryViewHoldAction::~TKinokoHistoryViewHoldAction()
{
}

void TKinokoHistoryViewHoldAction::Execute(void) throw(TKinokoException)
{
    _History->HoldSample(TMushDateTime::SecSinceEpoch());
}

void TKinokoHistoryViewHoldAction::Dump(std::ostream& os, const std::string& Indent)
{
    os << Indent << "Hold" << "\t" << _HistoryView->Name() << endl;
}



TKinokoHistoryViewSetOperationRangeAction::TKinokoHistoryViewSetOperationRangeAction(TKinokoHistoryView* HistoryView, double LowerBound, double UpperBound)
{
    _HistoryView = HistoryView;
    _LowerBound = LowerBound;
    _UpperBound = UpperBound;
}

TKinokoHistoryViewSetOperationRangeAction::~TKinokoHistoryViewSetOperationRangeAction()
{
}

void TKinokoHistoryViewSetOperationRangeAction::Execute(void) throw(TKinokoException)
{
    _HistoryView->SetOperationRange(_LowerBound, _UpperBound);
}

void TKinokoHistoryViewSetOperationRangeAction::Dump(ostream& os, const std::string& Indent)
{
    os << Indent << "SetOperationRange" << "\t" << _HistoryView->Name();
    os << ", " << _LowerBound << ", " << _UpperBound << endl;
}



TKinokoHistoryViewEnableAlarmAction::TKinokoHistoryViewEnableAlarmAction(TKinokoHistoryView* HistoryView, TKinokoEventEmitter* EventEmitter, const string& Message)
{
    _HistoryView = HistoryView;
    _EventEmitter = EventEmitter;
    _Message = Message;
}

TKinokoHistoryViewEnableAlarmAction::~TKinokoHistoryViewEnableAlarmAction()
{
}

void TKinokoHistoryViewEnableAlarmAction::Execute(void) throw(TKinokoException)
{
    _HistoryView->EnableAlarm(_EventEmitter, _Message);
}

void TKinokoHistoryViewEnableAlarmAction::Dump(ostream& os, const std::string& Indent)
{
    os << Indent << "EnableAlarm" << "\t" << _HistoryView->Name() << endl;
}



TKinokoHistoryViewDisableAlarmAction::TKinokoHistoryViewDisableAlarmAction(TKinokoHistoryView* HistoryView)
{
    _HistoryView = HistoryView;
}

TKinokoHistoryViewDisableAlarmAction::~TKinokoHistoryViewDisableAlarmAction()
{
}

void TKinokoHistoryViewDisableAlarmAction::Execute(void) throw(TKinokoException)
{
    _HistoryView->DisableAlarm();
}

void TKinokoHistoryViewDisableAlarmAction::Dump(ostream& os, const std::string& Indent)
{
    os << Indent << "DisableAlarm" << "\t" << _HistoryView->Name() << endl;
}
