/* KinokoViewBuilder.cc */
/* Created by Enomoto Sanshiro on 20 September 2001. */
/* Last updated by Enomoto Sanshiro on 16 June 2002. */


#include "KinokoViewFactory.hh"
#include "KinokoViewCanvas.hh"
#include "KinokoViewSequence.hh"
#include "KinokoViewBuilder.hh"

using namespace std;


TKinokoViewBuilder::TKinokoViewBuilder(TKinokoViewFactory* ViewFactory, TKinokoEventEmitter* EventEmitter, TKinokoRegistry* Registry)
{
    _ViewFactory = ViewFactory;
    _EventEmitter = EventEmitter;
    _Registry = Registry;

    _ViewCanvas = _ViewFactory->CreateViewCanvas();
    _SequenceTable = new TKinokoViewSequenceTable();

    _CurrentSequence = 0;
}

TKinokoViewBuilder::~TKinokoViewBuilder()
{
    _ViewCanvas->DestroyViews();

    for (unsigned i = 0; i < _RepositoryList.size(); i++) {
	delete _RepositoryList[i];
    }

    delete _ViewCanvas;
    delete _SequenceTable;
}

TKinokoViewFactory* TKinokoViewBuilder::ViewFactory(void)
{
    return _ViewFactory;
}

TKinokoViewCanvas* TKinokoViewBuilder::ViewCanvas(void)
{
    return _ViewCanvas;
}

TKinokoViewSequenceTable* TKinokoViewBuilder::SequenceTable(void)
{
    return _SequenceTable;
}

TKinokoEventEmitter* TKinokoViewBuilder::EventEmitter(void)
{
    return _EventEmitter;
}

TKinokoRegistry* TKinokoViewBuilder::Registry(void)
{
    return _Registry;
}

void TKinokoViewBuilder::AddView(TKinokoView* View)
{
    _ViewCanvas->AddView(View);
}

void TKinokoViewBuilder::AddAction(TKinokoViewAction* ViewAction)
{
    if (_CurrentSequence == 0) {
	throw TKinokoException("view action outside sequence");
    }

    _CurrentSequence->AddAction(ViewAction);
}

void TKinokoViewBuilder::OpenTrapSequence(int TrapId)
{
    if (_CurrentSequence != 0) {
	throw TKinokoException("invalid nested sequence");
    }

    _CurrentSequence = new TKinokoViewSequence();
    _SequenceTable->AddTrapSequence(TrapId, _CurrentSequence);
}

void TKinokoViewBuilder::OpenTimeSequence(int Interval_sec)
{
    if (_CurrentSequence != 0) {
	throw TKinokoException("invalid nested sequence");
    }

    _CurrentSequence = new TKinokoViewSequence();
    _SequenceTable->AddTimeSequence(Interval_sec, _CurrentSequence);
}

void TKinokoViewBuilder::OpenCommandSequence(const std::string& Command)
{
    if (_CurrentSequence != 0) {
	throw TKinokoException("invalid nested sequence");
    }

    _CurrentSequence = new TKinokoViewSequence();
    _SequenceTable->AddCommandSequence(Command, _CurrentSequence);
}

void TKinokoViewBuilder::CloseSequence(void)
{
    if (_CurrentSequence == 0) {
	throw TKinokoException("sequence not opened (internal)");
    }

    _CurrentSequence = 0;
}

void TKinokoViewBuilder::AddViewRepository(TKaspRepository* Repository)
{
    _RepositoryList.push_back(Repository);
}
