/* KinokoViewBuilder.hh */
/* Created by Enomoto Sanshiro on 20 September 2001. */
/* Last updated by Enomoto Sanshiro on 16 June 2002. */


#ifndef __KinokoViewBuilder_hh__
#define __KinokoViewBuilder_hh__


#include <vector>
#include "KaspRepository.hh"
#include "KinokoView.hh"
#include "KinokoViewCanvas.hh"
#include "KinokoViewSequence.hh"
#include "KinokoViewFactory.hh"
#include "KinokoPlatform.hh"


class TKinokoViewBuilder {
  public:
    TKinokoViewBuilder(TKinokoViewFactory* ViewFactory, TKinokoEventEmitter* EventEmitter, TKinokoRegistry* Registry);
    virtual ~TKinokoViewBuilder();
    virtual TKinokoViewFactory* ViewFactory(void);
    virtual TKinokoViewCanvas* ViewCanvas(void);
    virtual TKinokoViewSequenceTable* SequenceTable(void);
  public:
    virtual TKinokoEventEmitter* EventEmitter(void);
    virtual TKinokoRegistry* Registry(void);
    virtual void AddView(TKinokoView* View);
    virtual void AddAction(TKinokoViewAction* ViewAction);
    virtual void OpenTrapSequence(int TrapId);
    virtual void OpenTimeSequence(int Interval_sec);
    virtual void OpenCommandSequence(const std::string& Command);
    virtual void CloseSequence(void);
    virtual void AddViewRepository(TKaspRepository* Repository);
  protected:
    TKinokoViewFactory* _ViewFactory;
    TKinokoViewCanvas* _ViewCanvas;
    TKinokoViewSequenceTable* _SequenceTable;
    TKinokoEventEmitter* _EventEmitter;
    TKinokoRegistry* _Registry;
    std::vector<TKaspRepository*> _RepositoryList;
  private:
    TKinokoViewSequence* _CurrentSequence;
};


#endif
