/* KinokoViewCanvas.cc */
/* Created by Enomoto Sanshiro on 2 January 2001. */
/* Last updated by Enomoto Sanshiro on 14 June 2002. */


#include <string>
#include <vector>
#include "KinokoViewCanvas.hh"

using namespace std;


TKinokoViewCanvas::TKinokoViewCanvas(void)
{
    _RootFrame = new TKinokoViewGridFrame();
}

TKinokoViewCanvas::~TKinokoViewCanvas()
{
    delete _RootFrame;
}

void TKinokoViewCanvas::DestroyViews(void)
{
    for (unsigned i = 0; i < _ViewList.size(); i++) {
	delete _ViewList[i];
    }
}

void TKinokoViewCanvas::AddView(TKinokoView* View)
{
    _ViewList.push_back(View);
}

void TKinokoViewCanvas::DeployViews(void)
{
    _RootFrame->SetPosition(0, 0, 1.0, 1.0);

    for (unsigned i = 0; i < _ViewList.size(); i++) {
	if (_ViewList[i]->Parent() == 0) {
	    _RootFrame->AddView(_ViewList[i]);
	}
    }

    _RootFrame->Deploy();
}

void TKinokoViewCanvas::Update(void)
{
}



TKinokoKoapViewCanvas::TKinokoKoapViewCanvas(std::ostream* OutputStream)
{
    _OutputStream = OutputStream;
}

TKinokoKoapViewCanvas::~TKinokoKoapViewCanvas()
{
}

void TKinokoKoapViewCanvas::DeployViews(void)
{
    (*_OutputStream) << ".set redraw manual;" << endl;
    TKinokoViewCanvas::DeployViews();
    (*_OutputStream) << ".redraw;" << endl;
}

void TKinokoKoapViewCanvas::Update(void)
{
    TKinokoViewCanvas::Update();
    (*_OutputStream) << ".redraw;" << endl;
}

void TKinokoKoapViewCanvas::Clear(void)
{
    (*_OutputStream) << ".clear;" << endl;
    for (unsigned i = 0; i < _ViewList.size(); i++) {
	_ViewList[i]->Clear();
    }
    (*_OutputStream) << ".redraw;" << endl;
}

void TKinokoKoapViewCanvas::SaveImage(const std::string& ImageFileName)
{
    (*_OutputStream) << ".saveImage " << ImageFileName << ";" << endl;
}
