/* KinokoViewCanvas.hh */
/* Created by Enomoto Sanshiro on 14 June 2002. */
/* Last updated by Enomoto Sanshiro on 14 June 2002. */


#ifndef __KinokoViewCanvas_hh__
#define __KinokoViewCanvas_hh__


#include <string>
#include <vector>
#include "KinokoViewFrame.hh"


class TKinokoViewCanvas {
  public:
    TKinokoViewCanvas(void);
    virtual ~TKinokoViewCanvas();
    virtual void DestroyViews(void);
    virtual void AddView(TKinokoView* View);
    virtual void DeployViews(void);
    virtual void Update(void);
    virtual void Clear(void) = 0;
    virtual void SaveImage(const std::string& ImageFileName) = 0;
  protected:
    TKinokoViewFrame* _RootFrame;
    std::vector<TKinokoView*> _ViewList;
};


class TKinokoKoapViewCanvas: public TKinokoViewCanvas {
  public:
    TKinokoKoapViewCanvas(std::ostream* OutputStream);
    virtual ~TKinokoKoapViewCanvas();
    virtual void DeployViews(void);
    virtual void Update(void);
    virtual void Clear(void);
    virtual void SaveImage(const std::string& ImageFileName);
  protected:
    std::ostream* _OutputStream;
};


#endif
