/* KinokoViewFactory.cc */
/* Created by Enomoto Sanshiro on 4 November 2000. */
/* Last updated by Enomoto Sanshiro on 29 September 2002. */


#include <iostream>
#include "KinokoViewCanvas.hh"
#include "KinokoHistogramView.hh"
#include "Kinoko2dHistogramView.hh"
#include "KinokoHistoryView.hh"
#include "KinokoWaveView.hh"
#include "KinokoMapView.hh"
#include "KinokoTabularView.hh"
#include "KinokoPictureView.hh"
#include "KinokoViewFactory.hh"

using namespace std;


TKinokoViewFactory::TKinokoViewFactory(void)
{
}

TKinokoViewFactory::~TKinokoViewFactory()
{
}



TKinokoKoapViewFactory::TKinokoKoapViewFactory(ostream* OutputStream)
{
    _OutputStream = OutputStream;
}

TKinokoKoapViewFactory::~TKinokoKoapViewFactory()
{
}

TKinokoViewCanvas* TKinokoKoapViewFactory::CreateViewCanvas(void)
{
    return new TKinokoKoapViewCanvas(_OutputStream);
}

TKinokoHistogramView* TKinokoKoapViewFactory::CreateHistogramView(TKaspHistogram* Histogram)
{
    return new TKinokoKoapHistogramView(Histogram, _OutputStream);
}

TKinoko2dHistogramView* TKinokoKoapViewFactory::Create2dHistogramView(TKasp2dHistogram* Histogram)
{
    return new TKinokoKoap2dHistogramView(Histogram, _OutputStream);
}

TKinokoHistoryView* TKinokoKoapViewFactory::CreateHistoryView(TKaspHistory* History, double MaxValue, double MinValue, double WindowWidth)
{
    return new TKinokoKoapHistoryView(History, MaxValue, MinValue, WindowWidth, _OutputStream);
}

TKinokoWaveView* TKinokoKoapViewFactory::CreateWaveView(TKaspWave* Wave, double XMin, double XMax, double YMin, double YMax)
{
    return new TKinokoKoapWaveView(Wave, XMin, XMax, YMin, YMax, _OutputStream);
}

TKinokoMapView* TKinokoKoapViewFactory::CreateMapView(TKaspMap* Map, float XMin, float XMax, float YMin, float YMax, float ZMin, float ZMax)
{
    return new TKinokoKoapMapView(Map, XMin, XMax, YMin, YMax, ZMin, ZMax, _OutputStream);
}

TKinokoTabularView* TKinokoKoapViewFactory::CreateTabularView(TKaspTabular* Tabular, int NumberOfColumns)
{
    return new TKinokoKoapTabularView(Tabular, NumberOfColumns, _OutputStream);
}

TKinokoPictureView* TKinokoKoapViewFactory::CreatePictureView(const string& Title, float XMin, float XMax, float YMin, float YMax)
{
    return new TKinokoKoapPictureView(Title, XMin, XMax, YMin, YMax, _OutputStream);
}
    
TKinokoViewLineTrimming* TKinokoKoapViewFactory::CreateLineTrimming(TKinokoView* View, double x0, double y0, double x1, double y1)
{
    return new TKinokoViewKoapLineTrimming(View, x0, y0, x1, y1, _OutputStream);
}

TKinokoViewRectangleTrimming* TKinokoKoapViewFactory::CreateRectangleTrimming(TKinokoView* View, double x0, double y0, double x1, double y1)
{
    return new TKinokoViewKoapRectangleTrimming(View, x0, y0, x1, y1, _OutputStream);
}

TKinokoViewCircleTrimming* TKinokoKoapViewFactory::CreateCircleTrimming(TKinokoView* View, double x, double y, double r)
{
    return new TKinokoViewKoapCircleTrimming(View, x, y, r, _OutputStream);
}

TKinokoViewTextTrimming* TKinokoKoapViewFactory::CreateTextTrimming(TKinokoView* View, double x, double y, std::string Text)
{
    return new TKinokoViewKoapTextTrimming(View, x, y, Text, _OutputStream);
}

TKinokoViewImageTrimming* TKinokoKoapViewFactory::CreateImageTrimming(TKinokoView* View, double x, double y, std::string FileName)
{
    return new TKinokoViewKoapImageTrimming(View, x, y, FileName, _OutputStream);
}

TKinokoViewColorTrimming* TKinokoKoapViewFactory::CreateColorTrimming(TKinokoView* View, const string& ColorName)
{
    return new TKinokoViewKoapColorTrimming(View, ColorName, _OutputStream);
}

TKinokoViewTextAdjustmentTrimming* TKinokoKoapViewFactory::CreateTextAdjustmentTrimming(TKinokoView* View, const string& TextAdjustmentString)
{
    return new TKinokoViewKoapTextAdjustmentTrimming(View, TextAdjustmentString, _OutputStream);
}

TKinokoViewFontTrimming* TKinokoKoapViewFactory::CreateFontTrimming(TKinokoView* View, const string& FontName, int FontSize)
{
    return new TKinokoViewKoapFontTrimming(View, FontName, FontSize, _OutputStream);
}
