/* KinokoViewFactory.hh */
/* Created by Enomoto Sanshiro on 4 November 2000. */
/* Last updated by Enomoto Sanshiro on 29 September 2002. */


#ifndef __KinokoViewFactory_hh__
#define __KinokoViewFactory_hh__


#include <iostream>
#include <string>

#include "KinokoViewCanvas.hh"
#include "KinokoHistogramView.hh"
#include "Kinoko2dHistogramView.hh"
#include "KinokoHistoryView.hh"
#include "KinokoWaveView.hh"
#include "KinokoMapView.hh"
#include "KinokoTabularView.hh"
#include "KinokoPictureView.hh"
#include "KinokoViewTrimming.hh"


class TKinokoViewFactory {
  public:
    TKinokoViewFactory(void);
    virtual ~TKinokoViewFactory();
    virtual TKinokoViewCanvas* CreateViewCanvas(void) = 0;
    virtual TKinokoHistogramView* CreateHistogramView(TKaspHistogram* Histogram) = 0;
    virtual TKinoko2dHistogramView* Create2dHistogramView(TKasp2dHistogram* Histogram) = 0;
    virtual TKinokoHistoryView* CreateHistoryView(TKaspHistory* History, double MaxValue, double MinValue, double WindowWidth) = 0;
    virtual TKinokoWaveView* CreateWaveView(TKaspWave* Wave, double XMin, double XMax, double YMin, double YMax) = 0;
    virtual TKinokoMapView* CreateMapView(TKaspMap* Map, float XMin, float XMax, float YMin, float YMax, float ZMin, float ZMax) = 0;
    virtual TKinokoTabularView* CreateTabularView(TKaspTabular* Tabular, int NumberOfColumns) = 0;
    virtual TKinokoPictureView* CreatePictureView(const std::string& Title, float XMin, float XMax, float YMin, float YMax) = 0;
    virtual TKinokoViewRectangleTrimming* CreateRectangleTrimming(TKinokoView* View, double x0, double y0, double x1, double y1) = 0;
    virtual TKinokoViewCircleTrimming* CreateCircleTrimming(TKinokoView* View, double x, double y, double r) = 0;
    virtual TKinokoViewLineTrimming* CreateLineTrimming(TKinokoView* View, double x0, double y0, double x1, double y1) = 0;
    virtual TKinokoViewTextTrimming* CreateTextTrimming(TKinokoView* View, double x, double y, std::string Text) = 0;
    virtual TKinokoViewImageTrimming* CreateImageTrimming(TKinokoView* View, double x, double y, std::string FileName) = 0;
    virtual TKinokoViewColorTrimming* CreateColorTrimming(TKinokoView* View, const std::string& ColorName) = 0;
    virtual TKinokoViewTextAdjustmentTrimming* CreateTextAdjustmentTrimming(TKinokoView* View, const std::string& TextAdjustmentString) = 0;
    virtual TKinokoViewFontTrimming* CreateFontTrimming(TKinokoView* View, const std::string& FontName, int FontSize) = 0;
};


class TKinokoKoapViewFactory: public TKinokoViewFactory {
  public:
    TKinokoKoapViewFactory(std::ostream* OutputStream);
    virtual ~TKinokoKoapViewFactory();
    virtual TKinokoViewCanvas* CreateViewCanvas(void);
    virtual TKinokoHistogramView* CreateHistogramView(TKaspHistogram* Histogram);
    virtual TKinoko2dHistogramView* Create2dHistogramView(TKasp2dHistogram* Histogram);
    virtual TKinokoHistoryView* CreateHistoryView(TKaspHistory* History, double MaxValue, double MinValue, double WindowWidth);
    virtual TKinokoWaveView* CreateWaveView(TKaspWave* Wave, double XMin, double XMax, double YMin, double YMax);
    virtual TKinokoMapView* CreateMapView(TKaspMap* Map, float XMin, float XMax, float YMin, float YMax, float ZMin, float ZMax);
    virtual TKinokoTabularView* CreateTabularView(TKaspTabular* Tabular, int NumberOfColumns);
    virtual TKinokoPictureView* CreatePictureView(const std::string& Title, float XMin, float XMax, float YMin, float YMax);
    virtual TKinokoViewLineTrimming* CreateLineTrimming(TKinokoView* View, double x0, double y0, double x1, double y1);
    virtual TKinokoViewRectangleTrimming* CreateRectangleTrimming(TKinokoView* View, double x0, double y0, double x1, double y1);
    virtual TKinokoViewCircleTrimming* CreateCircleTrimming(TKinokoView* View, double x, double y, double r);
    virtual TKinokoViewTextTrimming* CreateTextTrimming(TKinokoView* View, double x, double y, std::string Text);
    virtual TKinokoViewImageTrimming* CreateImageTrimming(TKinokoView* View, double x, double y, std::string FileName);
    virtual TKinokoViewColorTrimming* CreateColorTrimming(TKinokoView* View, const std::string& ColorName);
    virtual TKinokoViewTextAdjustmentTrimming* CreateTextAdjustmentTrimming(TKinokoView* View, const std::string& TextAdjustmentString);
    virtual TKinokoViewFontTrimming* CreateFontTrimming(TKinokoView* View, const std::string& FontName, int FontSize);
  protected:
    std::ostream* _OutputStream;
};


#endif
