/* KinokoViewFrame.cc */
/* Created by Enomoto Sanshiro on 2 January 2001. */
/* Last updated by Enomoto Sanshiro on 14 June 2002. */


#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
#include "KinokoViewFrame.hh"

using namespace std;


TKinokoViewFrame::TKinokoViewFrame(void)
{
}

TKinokoViewFrame::~TKinokoViewFrame()
{
}

void TKinokoViewFrame::AddView(TKinokoView* View)
{
    View->SetParent(this);
    _ViewList.push_back(View);
}

void TKinokoViewFrame::DeployThis(void)
{
}

void TKinokoViewFrame::DrawThis(void)
{
}

void TKinokoViewFrame::ClearThis(void)
{
}

void TKinokoViewFrame::SaveThis(TKaspRepository* Repository) throw(TKinokoException)
{
}



TKinokoViewGridFrame::TKinokoViewGridFrame(int NumberOfColumns)
{
    _NumberOfColumns = NumberOfColumns;
}

TKinokoViewGridFrame::~TKinokoViewGridFrame()
{
}

void TKinokoViewGridFrame::Deploy(void)
{
    static const int ColumnCountTable[] = {
	// 1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16   // views
	0, 1, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4   // columns
	// 1  1  2  2  2  2  3  3  3  3  3  3  4  4  4  4   // rows
    };

    unsigned NumberOfViews = _ViewList.size();
    if (NumberOfViews == 0) {
	return;
    }

    if (_NumberOfColumns <= 0) {
	if (NumberOfViews < sizeof(ColumnCountTable) / sizeof(int)) {
	    _NumberOfColumns = ColumnCountTable[NumberOfViews];
	}
	else {
	    _NumberOfColumns = (int) sqrt((float) (NumberOfViews - 1)) + 1;
	}
    }

    int NumberOfRows = (NumberOfViews - 1) / _NumberOfColumns + 1;
    float Width = _Width / _NumberOfColumns;
    float Height = _Height / NumberOfRows;

    for (unsigned ViewIndex = 0; ViewIndex < NumberOfViews; ViewIndex++) {
	int Column = ViewIndex % _NumberOfColumns;
	int Row = ViewIndex / _NumberOfColumns;
	
	float Left = _Left + Width * Column;
	float Top = _Top + Height * Row;

	_ViewList[ViewIndex]->SetPosition(Left, Top, Width, Height);
	_ViewList[ViewIndex]->Deploy();
    }
}



TKinokoViewPlacerFrame::TKinokoViewPlacerFrame(void)
{
    _XMin = 0;
    _XMax = 1.0;
    _YMin = 0;
    _YMax = 1.0;
}

TKinokoViewPlacerFrame::TKinokoViewPlacerFrame(float XMin, float XMax, float YMin, float YMax)
{
    _XMin = min(XMin, XMax); 
    _XMax = max(XMin, XMax);
    _YMin = min(YMin, YMax);
    _YMax = max(YMin, YMax);
}

TKinokoViewPlacerFrame::~TKinokoViewPlacerFrame()
{
}

void TKinokoViewPlacerFrame::AddViewAt(TKinokoView* View, const TKinokoViewPlacement& Placement)
{
    AddView(View);
    _PlacementList.push_back(Placement);
}

void TKinokoViewPlacerFrame::Deploy(void)
{
    unsigned NumberOfViews = _ViewList.size();
    if (NumberOfViews == 0) {
	return;
    }

    for (unsigned ViewIndex = 0; ViewIndex < NumberOfViews; ViewIndex++) {
	TKinokoViewPlacement& Placement = _PlacementList[ViewIndex];

	float ThisLeft = (Placement.Left() - _XMin) / (_XMax - _XMin);
	float ThisTop = (Placement.Top() - _YMin) / (_YMax - _YMin);
	float ThisWidth = Placement.Width() / (_XMax - _XMin);
	float ThisHeight = Placement.Height() / (_YMax - _YMin);
	
	ThisLeft = _Left + _Width * ThisLeft;
	ThisTop = _Top + _Height * ThisTop;
	ThisWidth = _Width * ThisWidth;
	ThisHeight = _Height * ThisHeight;

	_ViewList[ViewIndex]->SetPosition(
	    ThisLeft, ThisTop, ThisWidth, ThisHeight
	);
	_ViewList[ViewIndex]->Deploy();
    }
}



float TKinokoViewPlacement::Left(void) const
{
    return (x0 < x1) ? x0 : x1;
}

float TKinokoViewPlacement::Top(void) const
{
    return (y0 < y1) ? y0 : y1;
}

float TKinokoViewPlacement::Width(void) const
{
    return (x0 < x1) ? (x1 - x0) : (x0 - x1); 
}

float TKinokoViewPlacement::Height(void) const
{
    return (y0 < y1) ? (y1 - y0) : (y0 - y1); 
}
