/* KinokoViewFrame.hh */
/* Created by Enomoto Sanshiro on 2 January 2001. */
/* Last updated by Enomoto Sanshiro on 14 June 2002. */


#ifndef __KinokoViewFrame_hh__
#define __KinokoViewFrame_hh__


#include <string>
#include <vector>
#include "KinokoView.hh"


class TKinokoViewFrame: public TKinokoView {
  public:
    TKinokoViewFrame(void);
    virtual ~TKinokoViewFrame();
    virtual void AddView(TKinokoView* View);
  protected:
    virtual void DeployThis(void);
    virtual void DrawThis(void);
    virtual void ClearThis(void);
    virtual void SaveThis(TKaspRepository* Repository) throw(TKinokoException);
  protected:
    std::vector<TKinokoView*> _ViewList;
};


class TKinokoViewGridFrame: public TKinokoViewFrame {
  public:
    TKinokoViewGridFrame(int NumberOfColumns = 0);
    virtual ~TKinokoViewGridFrame();
    virtual void Deploy(void);
  protected:
    int _NumberOfColumns;
};


class TKinokoViewPlacement {
  public:
    float Left(void) const;
    float Top(void) const;
    float Width(void) const;
    float Height(void) const;
  public:
    float x0, y0, x1, y1; 
};


class TKinokoViewPlacerFrame: public TKinokoViewFrame {
  public:
    TKinokoViewPlacerFrame(void);
    TKinokoViewPlacerFrame(float XMin, float XMax, float YMin, float YMax);
    virtual ~TKinokoViewPlacerFrame();
    virtual void AddViewAt(TKinokoView* View, const TKinokoViewPlacement& Placement);
    virtual void Deploy(void);
  public:
    std::vector<TKinokoViewPlacement> _PlacementList;
    float _XMin, _XMax, _YMin, _YMax;
};


#endif
