/* KinokoViewMessenger.hh */
/* Created by Enomoto Sanshiro on 31 December 2000. */
/* Last updated by Enomoto Sanshiro on 29 September 2002. */


#ifndef __KinokoViewMessenger_hh__
#define __KinokoViewMessenger_hh__


#include <string>
#include <vector>
#include "ParaPackage.hh"
#include "KaspRepository.hh"
#include "KinokoAnalysisMessenger.hh"
#include "KinokoAnalysisSequenceBuilder.hh"
#include "KinokoHistogramWriter.hh"
#include "Kinoko2dHistogramWriter.hh"
#include "KinokoHistoryWriter.hh"
#include "KinokoWaveWriter.hh"
#include "KinokoMapWriter.hh"
#include "KinokoTabularWriter.hh"
#include "KinokoView.hh"
#include "KinokoViewBuilder.hh"
#include "KinokoViewFrame.hh"
#include "KinokoViewSequence.hh"
#include "KinokoViewFactory.hh"


class TKinokoViewSystemMessenger: public TParaObjectPrototype {
  public:
    TKinokoViewSystemMessenger(TKinokoViewBuilder* ViewBuilder, const std::string& ScriptFileName);
    virtual ~TKinokoViewSystemMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    virtual int ScriptFileName(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int GetRegistry(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int SetRegistry(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    std::string _ScriptFileName;
    TKinokoViewBuilder* _ViewBuilder;
};


class TKinokoViewRepositoryMessenger: public TParaObjectPrototype {
  public:
    TKinokoViewRepositoryMessenger(TKinokoViewBuilder* ViewBuilder);
    virtual ~TKinokoViewRepositoryMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  public:
    virtual TKaspRepository* Repository(void);
  protected:
    TKinokoViewBuilder* _ViewBuilder;
    TKaspRepository* _Repository;
};


class TKinokoViewMessenger: public TParaObjectPrototype {
  public:
    TKinokoViewMessenger(TKinokoViewBuilder* ViewBuilder, TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder);
    virtual ~TKinokoViewMessenger();
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  public:
    virtual TKinokoView* View(void) = 0;
    virtual TKinokoDataAnalyzer* CreateAnalysisAction(std::vector<TKinokoDataElementMessenger*> DataElementMessengerList) = 0;
  protected:
    virtual int Fill(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue, bool IsSingleEventAction = false) throw(TScriptException);
    virtual int Draw(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int Clear(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int Save(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int PutLine(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int PutRectangle(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int PutCircle(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int PutText(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int PutImage(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int SetColor(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int SetTextAdjustment(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int SetFont(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    TKinokoViewBuilder* _ViewBuilder;
    TKinokoAnalysisSequenceBuilder* _AnalysisSequenceBuilder;
    TKinokoViewFactory* _ViewFactory;
};


class TKinokoViewGridMessenger: public TKinokoViewMessenger {
  public:
    TKinokoViewGridMessenger(TKinokoViewBuilder* ViewBuilder, TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder);
    virtual ~TKinokoViewGridMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  public:
    virtual TKinokoView* View(void);
    virtual TKinokoDataAnalyzer* CreateAnalysisAction(std::vector<TKinokoDataElementMessenger*> DataElementMessengerList);
  protected:
    virtual int PutView(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    TKinokoViewGridFrame* _Grid;
};


class TKinokoViewPlacerMessenger: public TKinokoViewMessenger {
  public:
    TKinokoViewPlacerMessenger(TKinokoViewBuilder* ViewBuilder, TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder);
    virtual ~TKinokoViewPlacerMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  public:
    virtual TKinokoView* View(void);
    virtual TKinokoDataAnalyzer* CreateAnalysisAction(std::vector<TKinokoDataElementMessenger*> DataElementMessengerList);
  protected:
    virtual int PutView(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    TKinokoViewPlacerFrame* _Placer;
};


class TKinokoHistogramViewMessenger: public TKinokoViewMessenger {
  public:
    TKinokoHistogramViewMessenger(TKinokoViewBuilder* ViewBuilder, TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder);
    virtual ~TKinokoHistogramViewMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  public:
    virtual TKinokoView* View(void);
    virtual TKinokoDataAnalyzer* CreateAnalysisAction(std::vector<TKinokoDataElementMessenger*> DataElementMessengerList);
  protected:
    virtual int SetYScaleLog(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int SetYScaleLinear(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int SetAxisTitle(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    std::string _Name;
    TKaspHistogram* _Histogram;
    TKinokoHistogramView* _HistogramView;
};


class TKinoko2dHistogramViewMessenger: public TKinokoViewMessenger {
  public:
    TKinoko2dHistogramViewMessenger(TKinokoViewBuilder* ViewBuilder, TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder);
    virtual ~TKinoko2dHistogramViewMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  public:
    virtual TKinokoView* View(void);
    virtual TKinokoDataAnalyzer* CreateAnalysisAction(std::vector<TKinokoDataElementMessenger*> DataElementMessengerList);
  protected:
    virtual int SetAxisTitle(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int DisableZScale(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int SetZScaleLog(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int SetZScaleLinear(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    std::string _Name;
    TKasp2dHistogram* _Histogram;
    TKinoko2dHistogramView* _HistogramView;
};


class TKinokoHistoryViewMessenger: public TKinokoViewMessenger {
  public:
    TKinokoHistoryViewMessenger(TKinokoViewBuilder* ViewBuilder, TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder);
    virtual ~TKinokoHistoryViewMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  public:
    virtual TKinokoView* View(void);
    virtual TKinokoDataAnalyzer* CreateAnalysisAction(std::vector<TKinokoDataElementMessenger*> DataElementMessengerList);
  protected:
    virtual int DrawCounts(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int DrawSum(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int DrawMean(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int DrawDeviation(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int SetYScaleLog(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int SetYScaleLinear(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int SetAxisTitle(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int Hold(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int SetOperationRange(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int EnableAlarm(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int DisableAlarm(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    std::string _Name;
    TKaspHistory* _History;
    TKinokoHistoryView* _HistoryView;
};


class TKinokoWaveViewMessenger: public TKinokoViewMessenger {
  public:
    TKinokoWaveViewMessenger(TKinokoViewBuilder* ViewBuilder, TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder);
    virtual ~TKinokoWaveViewMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  public:
    virtual TKinokoView* View(void);
    virtual TKinokoDataAnalyzer* CreateAnalysisAction(std::vector<TKinokoDataElementMessenger*> DataElementMessengerList);
  protected:
    virtual int SetAxisTitle(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    std::string _Name;
    TKaspWave* _Wave;
    TKinokoWaveView* _WaveView;
};


class TKinokoMapViewMessenger: public TKinokoViewMessenger {
  public:
    TKinokoMapViewMessenger(TKinokoViewBuilder* ViewBuilder, TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder);
    virtual ~TKinokoMapViewMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  public:
    virtual TKinokoView* View(void);
    virtual TKinokoDataAnalyzer* CreateAnalysisAction(std::vector<TKinokoDataElementMessenger*> DataElementMessengerList);
  protected:
    virtual int AddPoint(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int SetPointSize(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    std::string _Name;
    TKaspMap* _Map;
    TKinokoMapView* _MapView;
};


class TKinokoTabularViewMessenger: public TKinokoViewMessenger {
  public:
    TKinokoTabularViewMessenger(TKinokoViewBuilder* ViewBuilder, TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder);
    virtual ~TKinokoTabularViewMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  public:
    virtual TKinokoView* View(void);
    virtual TKinokoDataAnalyzer* CreateAnalysisAction(std::vector<TKinokoDataElementMessenger*> DataElementMessengerList);
  protected:
    std::string _Name;
    TKaspTabular* _Tabular;
    TKinokoTabularView* _TabularView;
};


class TKinokoPictureViewMessenger: public TKinokoViewMessenger {
  public:
    TKinokoPictureViewMessenger(TKinokoViewBuilder* ViewBuilder, TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder);
    virtual ~TKinokoPictureViewMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  public:
    virtual TKinokoView* View(void);
    virtual TKinokoDataAnalyzer* CreateAnalysisAction(std::vector<TKinokoDataElementMessenger*> DataElementMessengerList);
  protected:
    std::string _Name;
    TKinokoPictureView* _PictureView;
};


#endif
