/* KinokoViewScript.cc */
/* Created by Enomoto Sanshiro on 26 December 2000. */
/* Last updated by Enomoto Sanshiro on 20 September 2001. */


#include <string>
#include <vector>
#include "KiscScript.hh"
#include "KinokoAnalysisSequenceBuilder.hh"
#include "KinokoAnalysisMessenger.hh"
#include "KinokoAnalysisScriptStatement.hh"
#include "KinokoViewBuilder.hh"
#include "KinokoViewMessenger.hh"
#include "KinokoViewScriptStatement.hh"
#include "KinokoViewScript.hh"

using namespace std;


TKinokoViewScript::TKinokoViewScript(TKinokoViewBuilder* ViewBuilder, TKinokoAnalysisSequenceBuilder* AnalysisSequenceBuilder, const string& ScriptFileName)
{
    _ViewBuilder = ViewBuilder;
    _AnalysisSequenceBuilder = AnalysisSequenceBuilder;
    _ScriptFileName = ScriptFileName;
}

TKinokoViewScript::~TKinokoViewScript()
{
}

TParaTokenTable* TKinokoViewScript::CreateTokenTable(void)
{
    TParaTokenTable* TokenTable = TKiscScript::CreateTokenTable();

    TokenTable->AddKeyword("display");
    TokenTable->AddKeyword("analysis");
    TokenTable->AddKeyword("when");
    TokenTable->AddKeyword("invoke");
    TokenTable->AddKeyword("on");

    return TokenTable;
}

TParaOperatorTable* TKinokoViewScript::CreateOperatorTable(void)
{
    return TKiscScript::CreateOperatorTable();
}

TParaStatementTable* TKinokoViewScript::CreateStatementTable(void)
{
    TParaStatementTable* StatementTable;
    StatementTable = TKiscScript::CreateStatementTable();

    StatementTable->AddStatement(
	new TKinokoAnalysisScriptAnalysisStatement(_AnalysisSequenceBuilder)
    );
    StatementTable->AddStatement(
	new TKinokoAnalysisScriptWhenStatement(_AnalysisSequenceBuilder)
    );
    StatementTable->AddStatement(
	new TKinokoAnalysisScriptInvokeStatement(_AnalysisSequenceBuilder)
    );

    StatementTable->AddStatement(
	new TKinokoViewScriptOnStatement(_ViewBuilder)
    );

    return StatementTable;
}

TParaPackage* TKinokoViewScript::CreatePackage(void)
{
    TParaPackage* Package = TKiscScript::CreatePackage();

    Package->AddEntry(new TKinokoViewScriptDisplayEntry());

    return Package;
}

TParaObjectPrototypeTable* TKinokoViewScript::CreateObjectPrototypeTable(void)
{
    TParaObjectPrototypeTable* ObjectPrototypeTable;
    ObjectPrototypeTable = TKiscScript::CreateObjectPrototypeTable();

    ObjectPrototypeTable->RegisterClass(
	"DataElement", new TKinokoDataElementMessenger()
    );

    ObjectPrototypeTable->RegisterClass(
	"PlainTextViewRepository", new TKinokoViewRepositoryMessenger(_ViewBuilder)
    );
    ObjectPrototypeTable->RegisterClass(
	"XmlViewRepository", new TKinokoViewRepositoryMessenger(_ViewBuilder)
    );
    ObjectPrototypeTable->RegisterClass(
	"RootViewRepository", new TKinokoViewRepositoryMessenger(_ViewBuilder)
    );

    ObjectPrototypeTable->RegisterClass(
	"Grid", new TKinokoViewGridMessenger(
	    _ViewBuilder, _AnalysisSequenceBuilder
	)
    );
    ObjectPrototypeTable->RegisterClass(
	"Placer", new TKinokoViewPlacerMessenger(
	    _ViewBuilder, _AnalysisSequenceBuilder
	)
    );
    ObjectPrototypeTable->RegisterClass(
	"Histogram", new TKinokoHistogramViewMessenger(
	    _ViewBuilder, _AnalysisSequenceBuilder
	)
    );
    ObjectPrototypeTable->RegisterClass(
	"Histogram2d", new TKinoko2dHistogramViewMessenger(
	    _ViewBuilder, _AnalysisSequenceBuilder
	)
    );
    ObjectPrototypeTable->RegisterClass(
	"History", new TKinokoHistoryViewMessenger(
	    _ViewBuilder, _AnalysisSequenceBuilder
	)
    );
    ObjectPrototypeTable->RegisterClass(
	"MeanValueHistory", new TKinokoHistoryViewMessenger(
	    _ViewBuilder, _AnalysisSequenceBuilder
	)
    );
    ObjectPrototypeTable->RegisterClass(
	"TotalValueHistory", new TKinokoHistoryViewMessenger(
	    _ViewBuilder, _AnalysisSequenceBuilder
	)
    );
    ObjectPrototypeTable->RegisterClass(
	"EntryCountHistory", new TKinokoHistoryViewMessenger(
	    _ViewBuilder, _AnalysisSequenceBuilder
	)
    );
    ObjectPrototypeTable->RegisterClass(
	"Wave", new TKinokoWaveViewMessenger(
	    _ViewBuilder, _AnalysisSequenceBuilder
	)
    );
    ObjectPrototypeTable->RegisterClass(
	"Map", new TKinokoMapViewMessenger(
	    _ViewBuilder, _AnalysisSequenceBuilder
	)
    );
    ObjectPrototypeTable->RegisterClass(
	"Tabular", new TKinokoTabularViewMessenger(
	    _ViewBuilder, _AnalysisSequenceBuilder
	)
    );
    ObjectPrototypeTable->RegisterClass(
	"Picture", new TKinokoPictureViewMessenger(
	    _ViewBuilder, _AnalysisSequenceBuilder
	)
    );

    return ObjectPrototypeTable;
}

TParaBuiltinFunctionTable* TKinokoViewScript::CreateBuiltinFunctionTable(void)
{
    TParaBuiltinFunctionTable* FunctionTable;
    FunctionTable = TKiscScript::CreateBuiltinFunctionTable();

    FunctionTable->RegisterAnonymousClass(
	new TKinokoViewSystemMessenger(_ViewBuilder, _ScriptFileName)
    );

    return FunctionTable;
}

vector<string> TKinokoViewScript::DisplayNameList(void)
{
    vector<string> EntryNameList = _Package->EntryNameList();
    vector<string> NameList;

    for (unsigned i = 0; i < EntryNameList.size(); i++) {
	TParaPackageEntry* Entry = _Package->GetEntry(EntryNameList[i]);
	if ((Entry != 0) && (Entry->EntryTypeName() == "display")) {
	    NameList.push_back(EntryNameList[i]);
	}
    }

    return NameList;
}



TKinokoViewScriptDisplayEntry::TKinokoViewScriptDisplayEntry(void)
: TParaPackageEntry("display")
{
    _Statement = 0;
}

TKinokoViewScriptDisplayEntry::~TKinokoViewScriptDisplayEntry()
{
    delete _Statement;
}

TParaPackageEntry* TKinokoViewScriptDisplayEntry::Clone(void)
{
    return new TKinokoViewScriptDisplayEntry();
}

bool TKinokoViewScriptDisplayEntry::HasEntryWordsOf(TParaTokenizer* Tokenizer)
{
    return Tokenizer->LookAhead().Is("display");
}

void TKinokoViewScriptDisplayEntry::Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException)
{
    Tokenizer->Next().MustBe("display");
    string DisplayName = Tokenizer->Next().AsString();

    _Statement = StatementParser->Parse(Tokenizer, SymbolTable);

    SetEntryName(DisplayName);
}

TParaValue TKinokoViewScriptDisplayEntry::Execute(const vector<TParaValue*>& ArgumentList, TParaSymbolTable* SymbolTable) throw(TScriptException)
{
    return _Statement->Execute(SymbolTable).ReturnValue;
}
