/* KinokoViewSequence.hh */
/* Created by Enomoto Sanshiro on 16 June 2002. */
/* Last updated by Enomoto Sanshiro on 16 June 2002. */


#ifndef __KinokoViewSequence_hh__
#define __KinokoViewSequence_hh__


#include <string>
#include <vector>
#include <map>
#include "KinokoView.hh"
#include "KinokoViewAction.hh"


class TKinokoViewSequence {
  public:
    TKinokoViewSequence(void);
    virtual ~TKinokoViewSequence();
    virtual void AddAction(TKinokoViewAction* Action);
    virtual void Execute(void) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent);
  protected:
    TKinokoViewAction** _ActionList;
    int _ActionListSize;
    int _ActionListCapacity;
};


class TKinokoViewSequenceTable {
  public:
    TKinokoViewSequenceTable(void);
    virtual ~TKinokoViewSequenceTable();
    virtual void AddTimeSequence(long Interval_sec, TKinokoViewSequence* Sequence);
    virtual void AddTrapSequence(int TrapId, TKinokoViewSequence* Sequence);
    virtual void AddCommandSequence(const std::string& Command, TKinokoViewSequence* Sequence);
    virtual int ExecuteTimeSequence(void) throw(TKinokoException);
    virtual int ExecuteTrapSequence(int TrapId) throw(TKinokoException);
    virtual int ExecuteCommandSequence(const std::string& Command) throw(TKinokoException);
    virtual void Dump(std::ostream& os);
  protected:
    std::vector<std::pair<long, TKinokoViewSequence*> > _TimeSequenceTable;
    std::map<int, TKinokoViewSequence*> _TrapSequenceTable;
    std::map<std::string, TKinokoViewSequence*> _CommandSequenceTable;
    std::vector<long> _NextExecutionTimeTable;
  public:
    enum TTrapId {
	TrapId_Construct,
	TrapId_Destruct,
	TrapId_RunBegin,
	TrapId_RunEnd,
	TrapId_RunSuspend,
	TrapId_RunResume,
	TrapId_PreClear,
	TrapId_PostClear,
	_NumberOfTraps
    };
};


#endif
