/* KinokoViewTrimming.cc */
/* Created by Enomoto Sanshiro on 30 June 2002. */
/* Last updated by Enomoto Sanshiro on 30 June 2002. */


#include <string>
#include <iostream>
#include "KinokoView.hh"
#include "KinokoViewTrimming.hh"


using namespace std;


TKinokoViewTrimming::TKinokoViewTrimming(TKinokoView* View)
{
    _View = View;
}

TKinokoViewTrimming::~TKinokoViewTrimming()
{
}



TKinokoViewLineTrimming::TKinokoViewLineTrimming(TKinokoView* View, double x0, double y0, double x1, double y1)
: TKinokoViewTrimming(View)
{
    _x0 = x0;
    _y0 = y0;
    _x1 = x1;
    _y1 = y1;
}
    
TKinokoViewLineTrimming::~TKinokoViewLineTrimming()
{
}



TKinokoViewRectangleTrimming::TKinokoViewRectangleTrimming(TKinokoView* View, double x0, double y0, double x1, double y1)
: TKinokoViewTrimming(View)
{
    _x0 = x0;
    _y0 = y0;
    _x1 = x1;
    _y1 = y1;
}
    
TKinokoViewRectangleTrimming::~TKinokoViewRectangleTrimming()
{
}



TKinokoViewCircleTrimming::TKinokoViewCircleTrimming(TKinokoView* View, double x, double y, double r)
: TKinokoViewTrimming(View)
{
    _x = x;
    _y = y;
    _r = r;
}
    
TKinokoViewCircleTrimming::~TKinokoViewCircleTrimming()
{
}



TKinokoViewTextTrimming::TKinokoViewTextTrimming(TKinokoView* View, double x, double y, const string& Text)
: TKinokoViewTrimming(View)
{
    _x = x;
    _y = y;
    _Text = Text;
}

TKinokoViewTextTrimming::~TKinokoViewTextTrimming()
{
}



TKinokoViewImageTrimming::TKinokoViewImageTrimming(TKinokoView* View, double x, double y, const string& FileName)
: TKinokoViewTrimming(View)
{
    _x = x;
    _y = y;
    _FileName = FileName;
}

TKinokoViewImageTrimming::~TKinokoViewImageTrimming()
{
}



TKinokoViewColorTrimming::TKinokoViewColorTrimming(TKinokoView* View, const string& ColorName)
: TKinokoViewTrimming(View)
{
    _ColorName = ColorName;
}

TKinokoViewColorTrimming::~TKinokoViewColorTrimming()
{
}



TKinokoViewTextAdjustmentTrimming::TKinokoViewTextAdjustmentTrimming(TKinokoView* View, const string& TextAdjustmentString)
: TKinokoViewTrimming(View)
{
    _TextAdjustmentString = TextAdjustmentString;
}

TKinokoViewTextAdjustmentTrimming::~TKinokoViewTextAdjustmentTrimming()
{
}



TKinokoViewFontTrimming::TKinokoViewFontTrimming(TKinokoView* View, const string& FontName, int FontSize)
: TKinokoViewTrimming(View)
{
    _FontName = FontName;
    _FontSize = FontSize;
}

TKinokoViewFontTrimming::~TKinokoViewFontTrimming()
{
}



TKinokoViewKoapLineTrimming::TKinokoViewKoapLineTrimming(TKinokoView* View, double x0, double y0, double x1, double y1, ostream* OutputStream)
: TKinokoViewLineTrimming(View, x0, y0, x1, y1)
{
    _OutputStream = OutputStream;
    _Name = View->Name();
}

TKinokoViewKoapLineTrimming::~TKinokoViewKoapLineTrimming()
{
}

void TKinokoViewKoapLineTrimming::Draw(void)
{
    (*_OutputStream) << _Name << " drawline ";
    (*_OutputStream) << _x0 << " " << _y0 << " " << _x1 << " " << _y1 << ";";
    (*_OutputStream) << endl;
}



TKinokoViewKoapRectangleTrimming::TKinokoViewKoapRectangleTrimming(TKinokoView* View, double x0, double y0, double x1, double y1, ostream* OutputStream)
: TKinokoViewRectangleTrimming(View, x0, y0, x1, y1)
{
    _OutputStream = OutputStream;
    _Name = View->Name();
}

TKinokoViewKoapRectangleTrimming::~TKinokoViewKoapRectangleTrimming()
{
}

void TKinokoViewKoapRectangleTrimming::Draw(void)
{
    (*_OutputStream) << _Name << " drawrect ";
    (*_OutputStream) << _x0 << " " << _y0 << " " << _x1 << " " << _y1 << ";";
    (*_OutputStream) << endl;
}



TKinokoViewKoapCircleTrimming::TKinokoViewKoapCircleTrimming(TKinokoView* View, double x, double y, double r, ostream* OutputStream)
: TKinokoViewCircleTrimming(View, x, y, r)
{
    _OutputStream = OutputStream;
    _Name = View->Name();
}

TKinokoViewKoapCircleTrimming::~TKinokoViewKoapCircleTrimming()
{
}

void TKinokoViewKoapCircleTrimming::Draw(void)
{
    (*_OutputStream) << _Name << " drawcircle ";
    (*_OutputStream) << _x << " " << _y << " " << _r << ";";
    (*_OutputStream) << endl;
}



TKinokoViewKoapTextTrimming::TKinokoViewKoapTextTrimming(TKinokoView* View, double x, double y, const string& Text, ostream* OutputStream)
: TKinokoViewTextTrimming(View, x, y, Text)
{
    _OutputStream = OutputStream;
    _Name = View->Name();
}

TKinokoViewKoapTextTrimming::~TKinokoViewKoapTextTrimming()
{
}

void TKinokoViewKoapTextTrimming::Draw(void)
{
    (*_OutputStream) << _Name << " drawtext ";
    (*_OutputStream) << _x << " " << _y << " " << _Text << ";";
    (*_OutputStream) << endl;
}



TKinokoViewKoapImageTrimming::TKinokoViewKoapImageTrimming(TKinokoView* View, double x, double y, const string& FileName, ostream* OutputStream)
: TKinokoViewImageTrimming(View, x, y, FileName)
{
    _OutputStream = OutputStream;
    _Name = View->Name();
}

TKinokoViewKoapImageTrimming::~TKinokoViewKoapImageTrimming()
{
}

void TKinokoViewKoapImageTrimming::Draw(void)
{
    (*_OutputStream) << _Name << " drawimage ";
    (*_OutputStream) << _x << " " << _y << " " << _FileName << ";";
    (*_OutputStream) << endl;
}



TKinokoViewKoapColorTrimming::TKinokoViewKoapColorTrimming(TKinokoView* View, const string& ColorName, ostream* OutputStream)
: TKinokoViewColorTrimming(View, ColorName)
{
    _OutputStream = OutputStream;
    _Name = View->Name();
}

TKinokoViewKoapColorTrimming::~TKinokoViewKoapColorTrimming()
{
}

void TKinokoViewKoapColorTrimming::Draw(void)
{
    (*_OutputStream) << _Name << " set color " << _ColorName << ";" << endl;
}



TKinokoViewKoapTextAdjustmentTrimming::TKinokoViewKoapTextAdjustmentTrimming(TKinokoView* View, const string& TextAdjustmentString, ostream* OutputStream)
: TKinokoViewTextAdjustmentTrimming(View, TextAdjustmentString)
{
    _OutputStream = OutputStream;
    _Name = View->Name();
}

TKinokoViewKoapTextAdjustmentTrimming::~TKinokoViewKoapTextAdjustmentTrimming()
{
}

void TKinokoViewKoapTextAdjustmentTrimming::Draw(void)
{
    (*_OutputStream) << _Name << " set textadjustment " << _TextAdjustmentString << ";" << endl;
}



TKinokoViewKoapFontTrimming::TKinokoViewKoapFontTrimming(TKinokoView* View, const string& FontName, int FontSize, ostream* OutputStream)
: TKinokoViewFontTrimming(View, FontName, FontSize)
{
    _OutputStream = OutputStream;
    _Name = View->Name();
}

TKinokoViewKoapFontTrimming::~TKinokoViewKoapFontTrimming()
{
}

void TKinokoViewKoapFontTrimming::Draw(void)
{
    (*_OutputStream) << _Name;
    (*_OutputStream) << " setfont " << _FontName << " " << _FontSize;
    (*_OutputStream) << ";" << endl;
}
