/* KinokoViewer.hh */
/* Created by Enomoto Sanshiro on 31 October 2000. */
/* Last updated by Enomoto Sanshiro on 20 September 2001. */


#ifndef __KinokoViewer_hh__
#define __KinokoViewer_hh__


#include <iostream>
#include <string>
#include <vector>
#include "MushMisc.hh"
#include "KinokoPlatform.hh"
#include "KinokoDataProcessor.hh"
#include "KinokoDataDistributor.hh"
#include "KinokoDataAnalyzer.hh"
#include "KinokoAnalysisSequenceBuilder.hh"
#include "KinokoView.hh"
#include "KinokoViewFactory.hh"
#include "KinokoViewCanvas.hh"
#include "KinokoViewSequence.hh"
#include "KinokoViewBuilder.hh"
#include "KinokoViewScript.hh"


class TKinokoViewer: public TKinokoDataConsumer {
  public:
    TKinokoViewer(TKinokoEventEmitter* EventEmitter, TKinokoRegistry* Registry);
    virtual ~TKinokoViewer();
    virtual void OnConstruct(void) throw(TKinokoException);
    virtual void OnDestruct(void) throw(TKinokoException);
    virtual void OnRunBegin(void) throw(TKinokoException);
    virtual void OnRunEnd(void) throw(TKinokoException);
    virtual void OnReceiveDataPacket(void* DataPacket, long PacketSize) throw(TKinokoException);
    virtual void OnReceiveTrailerPacket(void* DataPacket, long PacketSize) throw(TKinokoException);
    virtual int ProcessData(void) throw(TKinokoException);
  public:
    virtual void SetScript(const std::string& ScriptFileName, const std::string& DisplayEntryName = "");
    virtual int ExecuteCommand(const std::string& Command) throw(TKinokoException);
    virtual void Reset(void);
    virtual void SaveImage(const std::string& ImageFileName);
  protected:
    std::string _ScriptFileName;
    std::string _DisplayEntryName;
    std::ostream* _OutputStream;
    TKinokoEventEmitter* _EventEmitter;
    TKinokoRegistry* _Registry;
    TKinokoAnalysisSequenceBuilder* _AnalysisSequenceBuilder;
    TKinokoViewBuilder* _ViewBuilder;
    TKinokoViewFactory* _ViewFactory;
    TKinokoViewScript* _ViewScript;
    TKinokoViewCanvas* _ViewCanvas;
    TKinokoViewSequenceTable* _ViewSequenceTable;
    TKinokoDataDistributor* _DataDistributor;
    std::vector<TKinokoAnalysisSequence*> _AnalysisSequenceList;
    bool _IsFirstRun;
    bool _IsRunning;
};


#endif
