/* KinokoWaveView.cc */
/* Created by Enomoto Sanshiro on 2 April 2001. */
/* Last updated by Enomoto Sanshiro on 2 April 2001. */


#include <strstream>
#include <cmath>
#include "KaspWave.hh"
#include "KinokoWaveView.hh"

using namespace std;


TKinokoWaveView::TKinokoWaveView(TKaspWave* Wave, double XMin, double XMax, double YMin, double YMax)
{
    _Wave = Wave;

    _XMin = XMin;
    _XMax = XMax;
    _YMin = YMin;
    _YMax = YMax;
}

TKinokoWaveView::~TKinokoWaveView()
{
}

void TKinokoWaveView::SetAxisTitle(const std::string& XTitle, const std::string& YTitle)
{
    _XTitle = XTitle;
    _YTitle = YTitle;
}

void TKinokoWaveView::SaveThis(TKaspRepository* Repository)throw(TKinokoException)
{
    try {
	Repository->SaveWave(_Name, _Wave);
    }
    catch (TKaspException &e) {
	throw TKinokoException(
	    "TKinokoWaveView::SaveThis()", e.Message()
	);
    }
}


void TKinokoWaveView::ClearThis(void)
{
    _Wave->Clear();
}


TKinokoKoapWaveView::TKinokoKoapWaveView(TKaspWave* Wave, double XMin, double XMax, double YMin, double YMax, ostream* OutputStream)
: TKinokoWaveView(Wave, XMin, XMax, YMin, YMax)
{
    _OutputStream = OutputStream;
}

TKinokoKoapWaveView::~TKinokoKoapWaveView()
{
}

void TKinokoKoapWaveView::DeployThis(void) 
{
    (*_OutputStream) << ".create plot " << _Name << " ";
    (*_OutputStream) << 100 * Left() << " " << 100 * Top() << " ";
    (*_OutputStream) << 100 * Width() << " " << 100 * Height() << ";" << endl;

    (*_OutputStream) << _Name << " set title " << _Wave->Title() << ";" << endl;
    if (! _XTitle.empty()) {
	(*_OutputStream) << _Name << " set xtitle " << _XTitle << ";" << endl;
    }
    if (! _YTitle.empty()) {
	(*_OutputStream) << _Name << " set ytitle " << _YTitle << ";" << endl;
    }

    (*_OutputStream) << _Name << " frame ";
    (*_OutputStream) << _XMin << " " << _XMax << " ";
    (*_OutputStream) << _YMin << " " << _YMax << ";" << endl;
}

void TKinokoKoapWaveView::DrawThis(void)
{
    (*_OutputStream) << _Name << " clear;" << endl;
    (*_OutputStream) << _Name << " frame ";
    (*_OutputStream) << _XMin << " " << _XMax << " ";
    (*_OutputStream) << _YMin << " " << _YMax << ";" << endl;

    if (! _Wave->HasData()) {
        (*_OutputStream) << _Name << " drawtext ";
        (*_OutputStream) << (7 * _XMin + _XMax) / 8 << " ";
        (*_OutputStream) << (_YMin + _YMax) / 2 << " ";
        (*_OutputStream) << "no data;" << endl;
	return;
    }

    (*_OutputStream) << _Name << " linesplot ";
    int NumberOfPoints = _Wave->NumberOfPoints();
    for (int Index = 0; Index < NumberOfPoints; Index++) {
	if ((Index >= _XMin) && (Index <= _XMax)) {
	    (*_OutputStream) << " " << Index << " " << _Wave->ValueOf(Index);
	}
    }
    (*_OutputStream) << ";" << endl;

    (*_OutputStream) << _Name << " drawframe;";
}

void TKinokoKoapWaveView::ClearThis(void)
{
    TKinokoWaveView::ClearThis();
    
    (*_OutputStream) << _Name << " clear;" << endl;
    (*_OutputStream) << _Name << " frame ";
    (*_OutputStream) << _XMin << " " << _XMax << " ";
    (*_OutputStream) << _YMin << " " << _YMax << ";" << endl;
}
