/* KinokoWaveView.hh */
/* Created by Enomoto Sanshiro on 2 April 2001. */
/* Last updated by Enomoto Sanshiro on 2 April 2001. */


#ifndef __KinokoWaveView_hh__
#define __KinokoWaveView_hh__


#include <iostream>
#include "KaspWave.hh"
#include "KinokoView.hh"


class TKinokoWaveView: public TKinokoView {
  public:
    TKinokoWaveView(TKaspWave* Wave, double XMin, double XMax, double YMin, double YMax);
    virtual ~TKinokoWaveView();
    virtual void SetAxisTitle(const std::string& XTitle, const std::string& YTitle);
  protected:
    virtual void SaveThis(TKaspRepository* Repository) throw(TKinokoException);
    virtual void ClearThis(void);
  protected:
    TKaspWave* _Wave;
    double _XMin, _XMax, _YMin, _YMax;
    std::string _XTitle, _YTitle;
};



class TKinokoKoapWaveView: public TKinokoWaveView {
  public:
    TKinokoKoapWaveView(TKaspWave* Wave, double XMin, double XMax, double YMin, double YMax, std::ostream* OutputStream);
    virtual ~TKinokoKoapWaveView();
  protected:
    virtual void DeployThis(void);
    virtual void DrawThis(void);
    virtual void ClearThis(void);
  protected:
    std::ostream* _OutputStream;
};


#endif
