/* KinokoBuffer-kcom.cc */
/* Created by Enomoto Sanshiro on 29 October 2000. */
/* Last updated by Enomoto Sanshiro on 20 October 2000. */


#include <iostream>
#include "KcomProcess.hh"
#include "KinokoBufferCom.hh"

using namespace std;


int main(int argc, char** argv)
{
    TMushSignalHandler SignalHandler;
    SignalHandler.StartDefaultAction(SIGSEGV);
    SignalHandler.StartDefaultAction(SIGPIPE);

    TMushArgumentList ArgumentList(argc, argv);
    
    TKcomComponent* Component = new TKinokoBufferCom();
    TKcomProcess* ComProcess = new TKcomProcess(Component);
    
    try {
	ComProcess->Start(ArgumentList);
    }
    catch (TKcomException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }

    delete ComProcess;
    delete Component;

    return 0;
}
