/* KinokoConsole-kcom.cc */
/* Created by Enomoto Sanshiro on 23 August 2002. */
/* Last updated by Enomoto Sanshiro on 23 August 2002. */


#include <iostream>
#include "KcomProcess.hh"
#include "KinokoConsoleCom.hh"

using namespace std;


int main(int argc, char** argv)
{
    TMushSignalHandler SignalHandler;
    SignalHandler.StartDefaultAction(SIGSEGV);
    SignalHandler.StartDefaultAction(SIGPIPE);

    TMushArgumentList ArgumentList(argc, argv);
    
    TKcomComponent* Component = new TKinokoConsoleCom();
    TKcomProcess* ComProcess = new TKcomProcess(Component);
    
    try {
	ComProcess->Start(ArgumentList);
    }
    catch (TKcomException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }

    delete ComProcess;
    delete Component;

    return 0;
}
