/* KinokoDataProcessor-kcom.cc */
/* Created by Enomoto Sanshiro on 23 April 2001. */
/* Last updated by Enomoto Sanshiro on 23 April 2001. */


//== NOTE ==////////////////////////////////////////////////////////////////
//
//  This is an example program for user defined data-processing components.
//  The include file "MyDataProcessor.hh" and the class "MyDataProcessor"
//  are user defined. Make sure that the include file and the class are
//  replaced before compiling this program.
//
//  In this program DataProcessor is used as an example. If you use
//  DataProducer or DataConsumer instead, use TKinokoDataProducerCom or
//  TKinokoDataConsumerCom for its wrapper component, respectively.
//
////////////////////////////////////////////////////////////////////////////


#include <iostream>
#include "KcomProcess.hh"
#include "KinokoDataProcessorCom.hh"

#include "MyDataProcessor.hh"

using namespace std;


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);
    
    TKinokoDataProcessor* MyDataProcessor = new TMyDataProcessor();
    TKcomComponent* Component = new TKinokoDataProcessorCom(MyDataProcessor);
    TKcomProcess* ComProcess = new TKcomProcess(Component);    

    try {
	ComProcess->Start(ArgumentList);
    }
    catch (TKcomException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }

    delete ComProcess;
    delete Component;
    delete MyDataProcessor;

    return 0;
}
