/* KinokoRecorder-kcom.cc */
/* Created by Enomoto Sanshiro on 11 October 2000. */
/* Last updated by Enomoto Sanshiro on 11 October 2000. */


#include <iostream>
#include "KcomProcess.hh"
#include "KinokoRecorderCom.hh"

using namespace std;


int main(int argc, char** argv)
{
    TMushSignalHandler SignalHandler;
    SignalHandler.StartDefaultAction(SIGSEGV);
    SignalHandler.StartDefaultAction(SIGPIPE);

    TMushArgumentList ArgumentList(argc, argv);
    
    TKcomComponent* Component = new TKinokoRecorderCom();
    TKcomProcess* ComProcess = new TKcomProcess(Component);
    
    try {
	ComProcess->Start(ArgumentList);
    }
    catch (TKcomException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }

    delete ComProcess;
    delete Component;

    return 0;
}
