/* kcksum.cc */
/* Created by Enomoto Sanshiro on 14 February 2002 */
/* Last updated by Enomoto Sanshiro on 16 February 2002. */


#include <iostream>
#include "MushArgumentList.hh"
#include "MushFileSystem.hh"

using namespace std;


unsigned int OldCheckSum(const string& FileName) throw(TSystemCallException);


int main(int argc, char **argv)
{
    TMushArgumentList ArgumentList(argc, argv);

    if (ArgumentList.NumberOfParameters() < 1) {
	cerr << "Usage: " << argv[0] << " [OPTIONS] FileName" << endl;;
	cerr << "Options: " << endl;
	cerr << "  --dec  output in decimal number" << endl;
	cerr << "  --old  use old CRC calculation" << endl;
	return EXIT_FAILURE;
    }
    
    string FileName = ArgumentList[0];
    try {
	if (ArgumentList.IsOptionSpecified("--dec")) {
	    cout << dec;
	}
	else {
	    cout << hex;
	}

	if (ArgumentList.IsOptionSpecified("--old")) {
	    cout << OldCheckSum(FileName) << endl;
	}
	else {
	    cout << TMushFileAttribute(FileName).CheckSum() << endl;
	}
    }
    catch (TSystemCallException &e) {
	cerr << "ERROR: " << e << endl;
	return EXIT_FAILURE;
    }

    return 0;
}



#include <fstream>
#include <sys/stat.h>

unsigned int OldCheckSum(const string& FileName) throw(TSystemCallException)
{
    static const long CrcPoly32 = 0xedb88320; // right to left

    struct stat FileStat;
    if (stat(FileName.c_str(), &FileStat) < 0) {
        throw TSystemCallException("stat(2)");
    }
    int FileSize = FileStat.st_size;
    int BufferSize = FileSize + 1;
    char* Buffer = new char[BufferSize];

    ifstream File(FileName.c_str());
    if (! File) {
        throw TSystemCallException("unable to open file", FileName);
    }
    File.read(Buffer, FileSize);
    Buffer[FileSize] = '\0';

    unsigned r = 0xffffffff;
    for (int i = 0; i < FileSize; i++) {
        r ^= Buffer[i];
        for (int j = 0; j < 8; j++) {
            if (r & 0x00000001) {
                r = (r >> 1) ^ CrcPoly32;
            }
            else {
                r >>= 1;
            }
        }
    }

    return r ^ 0xffffffff;
}
